set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8412703';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4323',
      '42120013',
      NULL,
      '42042344',
      '34422104',
      '20412043',
      '24340403',
      NULL,
      '34210243',
      '23011143',
      '31411003',
      '10313322',
      NULL,
      NULL,
      '22433413',
      NULL,
      '30433421',
      '30133434',
      '43234134',
      '23011033',
      '00214014',
      NULL,
      NULL,
      '33021442',
      '13322144',
      '32423124',
      NULL,
      '11231401',
      '34003011',
      '20224201',
      NULL,
      '32004223',
      '43001034',
      NULL,
      '13023410',
      '34132343',
      NULL,
      '20022342',
      NULL,
      '04432021',
      '41314300',
      '40144232',
      '12343112',
      NULL,
      '32021040',
      '212',
      '11',
      NULL,
      15,
      '1242413',
      1.050803,
      83,
      0,
      NULL,
      '412340',
      4,
      NULL,
      NULL,
      47.023203,
      52.598209,
      20.911837,
      13,
      11,
      11.374756,
      29.788275,
      10.733138,
      6,
      5,
      5.900142,
      8,
      3,
      5,
      3,
      11.237633,
      NULL,
      11,
      48.995685,
      0.225328,
      31.516717,
      11.877996,
      16,
      1,
      NULL,
      57.015672,
      37.943013,
      6,
      153.311004,
      49,
      94,
      ' 9-15-1991',
      2.979621,
      26.978265,
      16.558852,
      5.201169,
      NULL,
      90.570075,
      ' 3-26-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      52,
      35,
      NULL,
      NULL,
      23,
      NULL,
      ' 6-29-1983',
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      0.112507,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-19-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.512536,
      16,
      15.371546,
      7.196236,
      13,
      3.605305,
      2,
      ' 9-12-1977',
      1.053525,
      3,
      '10-13-1976',
      NULL,
      2,
      5.929530,
      NULL,
      2.474327,
      2.765180,
      1.612536,
      6.819637,
      0,
      NULL,
      NULL,
      3,
      6.188383,
      14.162538,
      5,
      2.234898,
      4,
      4.295529,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      84,
      1.511106,
      ' 1-12-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 5-1998',
      17,
      ' 1-26-1990',
      NULL,
      4.997813,
      '10- 3-1979',
      98.955361,
      NULL,
      ' 4-23-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      ' 3-29-1989',
      19.130333,
      NULL,
      NULL,
      NULL,
      2.703694,
      106.770567,
      NULL,
      1.241917,
      33.089060,
      NULL,
      122,
      NULL,
      32.595178,
      1.223007,
      80.356872,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


