set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8412703';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '4',
      '1',
      NULL,
      '3',
      '1',
      NULL,
      '3',
      '4',
      '1',
      '4',
      '2',
      NULL,
      '0',
      '1',
      NULL,
      '1',
      '2',
      '4',
      NULL,
      '4',
      '0',
      '4',
      '4',
      '',
      '0',
      '',
      '3',
      '1',
      NULL,
      '2',
      '0',
      '',
      '',
      '0',
      NULL,
      '3',
      '1',
      '2',
      NULL,
      '3',
      '2',
      NULL,
      NULL,
      NULL,
      '212',
      '00004213',
      48.647104,
      21,
      '3234013',
      NULL,
      56,
      3,
      NULL,
      '301340',
      4.247251,
      '10-10-1995',
      ' 5-13-1989',
      17.452878,
      NULL,
      3.969996,
      8.145097,
      3,
      12.543450,
      35.783037,
      6.348006,
      4.093853,
      NULL,
      22.577264,
      5.780279,
      41.841053,
      19.724530,
      15.470727,
      14.601938,
      4,
      11.874950,
      0,
      17.412674,
      NULL,
      NULL,
      59.434301,
      0,
      0,
      59,
      10.154041,
      6,
      158,
      127,
      NULL,
      ' 6- 3-1987',
      4,
      31,
      17,
      15,
      27.730145,
      51.899629,
      ' 2- 7-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      72.045741,
      NULL,
      21.096783,
      NULL,
      9,
      3.998169,
      ' 8- 7-1982',
      0,
      1.434165,
      58,
      1.794442,
      NULL,
      26,
      0.324184,
      0,
      23,
      NULL,
      NULL,
      NULL,
      ' 1- 6-1997',
      25,
      50.610313,
      66,
      9,
      26,
      7,
      NULL,
      NULL,
      19.701996,
      34.270381,
      NULL,
      16.247061,
      ' 1-16-1977',
      6,
      6,
      14.699224,
      NULL,
      59.636761,
      NULL,
      8,
      '11- 6-1981',
      7,
      1,
      NULL,
      5.283650,
      4,
      8,
      17,
      NULL,
      2.358386,
      5.093861,
      10.872890,
      1.287918,
      63,
      1,
      0,
      5.258625,
      7.362108,
      1.061451,
      NULL,
      1.576547,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      124.602470,
      NULL,
      '11-25-1974',
      NULL,
      NULL,
      NULL,
      16.867922,
      ' 1- 3-1995',
      33.784359,
      NULL,
      NULL,
      9.735266,
      ' 2-19-1985',
      NULL,
      43,
      ' 8-12-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      13.040094,
      ' 9-20-2003',
      61.461106,
      19.874626,
      24,
      ' 2- 4-1994',
      1.451236,
      179.646175,
      NULL,
      11.183153,
      NULL,
      NULL,
      35.206464,
      ' 4-29-1994',
      19.839628,
      0.902038,
      106,
      ' 3-27-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


