set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8412703';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '3',
      '0',
      NULL,
      '1',
      '4',
      '4',
      NULL,
      NULL,
      '0',
      '0',
      '3',
      '0',
      '0',
      NULL,
      NULL,
      '4',
      '3',
      '1',
      '0',
      NULL,
      '1',
      '0',
      '0',
      '',
      '3',
      '',
      '1',
      '0',
      '1',
      '3',
      '1',
      NULL,
      '',
      '1',
      '4',
      '4',
      '4',
      '3',
      '2',
      '1',
      NULL,
      NULL,
      NULL,
      NULL,
      '210',
      '00002234',
      80,
      NULL,
      '1231200',
      0,
      258,
      NULL,
      1,
      '041414',
      0,
      ' 7- 0-1981',
      NULL,
      32.708240,
      NULL,
      NULL,
      10,
      13,
      17,
      4,
      8,
      8.839550,
      13.642515,
      NULL,
      11.777490,
      0.887829,
      11,
      22,
      5.890431,
      0,
      10,
      3,
      NULL,
      9.578236,
      1,
      46.316668,
      1.551437,
      0,
      36,
      107.186361,
      17,
      165,
      16,
      158,
      NULL,
      NULL,
      23.050508,
      7,
      10.971647,
      NULL,
      197,
      ' 0-13-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      24.071716,
      NULL,
      31,
      3,
      1.030688,
      ' 3-25-1978',
      0,
      1.110230,
      NULL,
      1,
      0,
      79,
      NULL,
      1,
      63.649105,
      NULL,
      NULL,
      NULL,
      ' 4- 9-1974',
      39,
      53.085261,
      57.821923,
      26.800630,
      76,
      22.330198,
      67.631515,
      NULL,
      8,
      54.520013,
      6,
      49.505746,
      NULL,
      11.049844,
      1.754294,
      6,
      NULL,
      27.056851,
      2,
      5.819197,
      ' 6-24-1975',
      11,
      4,
      ' 9-21-1997',
      9.761125,
      0.574554,
      0.707767,
      NULL,
      4,
      0.034312,
      3.331890,
      4.527649,
      NULL,
      37,
      1.887766,
      NULL,
      1,
      NULL,
      0.456628,
      3,
      1,
      NULL,
      ' 8-24-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      29,
      11.940485,
      ' 1-11-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-12-1981',
      19,
      '11-13-1979',
      NULL,
      NULL,
      ' 2- 9-1975',
      NULL,
      11.041186,
      ' 2-12-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      ' 3-28-2003',
      4.056981,
      NULL,
      0.183431,
      ' 2-10-1975',
      1,
      196.297857,
      ' 6- 5-1982',
      2,
      29,
      2.387694,
      NULL,
      ' 2- 6-2001',
      NULL,
      0.687362,
      58.349598,
      ' 6- 0-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


