set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6811617';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4422',
      '34433344',
      '11131142',
      '02442234',
      '10333001',
      '22012341',
      '30133002',
      '21222322',
      '33201421',
      '04243420',
      '31344420',
      '03314212',
      '24323020',
      NULL,
      '31321130',
      '03404214',
      NULL,
      NULL,
      '20413013',
      '01242403',
      '40111030',
      '30121202',
      '31021313',
      '31113033',
      '31214401',
      NULL,
      NULL,
      NULL,
      NULL,
      '00433431',
      '21112320',
      '03312334',
      '24404303',
      '34010123',
      '02412013',
      '13322310',
      '21031102',
      '43022004',
      '32002224',
      NULL,
      '44243020',
      '32120122',
      '22243223',
      '40202004',
      NULL,
      '144',
      NULL,
      42,
      17.450751,
      '1423003',
      2.394071,
      0,
      0,
      NULL,
      '400403',
      3.768480,
      '10-10-1993',
      NULL,
      49.895388,
      7.330640,
      4,
      8.810456,
      NULL,
      6,
      NULL,
      11,
      17,
      2,
      19.864656,
      11.774449,
      19.085530,
      10.738322,
      NULL,
      NULL,
      NULL,
      5.256287,
      28.478874,
      3.423769,
      10.937698,
      4.828289,
      20,
      15,
      0.788182,
      16.854530,
      101,
      10,
      NULL,
      89.040036,
      NULL,
      ' 1-28-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.792759,
      0,
      77.203147,
      0.406916,
      0.365700,
      76,
      0,
      3,
      59.561048,
      NULL,
      NULL,
      NULL,
      ' 6- 9-2001',
      68.208690,
      33,
      14.693165,
      23,
      78.995237,
      50.372055,
      46,
      17,
      67.824142,
      107.376217,
      17.875093,
      72.174747,
      ' 0- 9-2002',
      NULL,
      8,
      15.117210,
      46.930806,
      NULL,
      23.636284,
      NULL,
      '11-10-1989',
      NULL,
      NULL,
      NULL,
      5,
      7,
      14.377607,
      7.360743,
      6,
      4.967305,
      1.783037,
      8.256770,
      1.737648,
      48,
      0,
      0,
      14,
      NULL,
      0,
      NULL,
      0,
      1,
      ' 2-29-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      51,
      74,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      2,
      ' 1-27-1999',
      NULL,
      29.087259,
      14.989442,
      ' 9- 8-1993',
      0.424971,
      100.494365,
      ' 3-15-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


