set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8919099';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1443',
      '34113020',
      '41234123',
      NULL,
      '20421042',
      '22301011',
      '31213031',
      '02000143',
      '01144102',
      '22200032',
      NULL,
      '21130210',
      NULL,
      NULL,
      '12031431',
      '02241131',
      '22441221',
      NULL,
      NULL,
      NULL,
      '34313402',
      '43203323',
      '12133403',
      '24301201',
      '44313101',
      NULL,
      '43011143',
      '00220411',
      '13033133',
      '44323141',
      '11312404',
      '04231112',
      '32043231',
      '00234421',
      '00420430',
      '20332223',
      '30343303',
      '42244114',
      '40132213',
      '34202422',
      '31001434',
      '32404433',
      '34111421',
      '40444033',
      NULL,
      '030',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      '414332',
      NULL,
      NULL,
      ' 6-23-1983',
      37,
      NULL,
      47.243892,
      21,
      31.960636,
      8.727983,
      12,
      NULL,
      32.347202,
      9,
      54,
      7.912755,
      NULL,
      23.523338,
      4,
      15.753522,
      27.020750,
      21.074461,
      2.428120,
      15.765965,
      8,
      3.026667,
      25,
      9,
      0,
      15,
      55,
      13,
      70,
      NULL,
      207.136546,
      ' 1-22-1987',
      75.270988,
      17.588416,
      11.173068,
      24.602916,
      NULL,
      52.861119,
      NULL,
      1.998147,
      1,
      NULL,
      2,
      NULL,
      3,
      0,
      NULL,
      1.246504,
      NULL,
      NULL,
      0,
      NULL,
      3,
      1.690425,
      0.106092,
      3,
      0,
      1,
      1.137264,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-12-1989',
      19,
      38.210198,
      NULL,
      10,
      6,
      2,
      ' 0-21-1992',
      1,
      NULL,
      158.131885,
      0,
      NULL,
      11.503195,
      1.314827,
      1,
      48.873008,
      NULL,
      NULL,
      NULL,
      '11-17-1981',
      43.976293,
      16,
      NULL,
      59.015983,
      10.904685,
      42.528664,
      NULL,
      2,
      NULL,
      14,
      NULL,
      14,
      ' 8-14-1981',
      49.373752,
      30.415942,
      5.618051,
      NULL,
      NULL,
      61,
      NULL,
      ' 6- 9-1998',
      24,
      NULL,
      NULL,
      8.908579,
      8,
      NULL,
      16.243195,
      21.444053,
      9.890218,
      0.862472,
      NULL,
      1,
      77.319640,
      1,
      1.851753,
      3.697207,
      NULL,
      0.916590,
      0.717230,
      NULL,
      NULL,
      ' 4- 7-1991',
      8.389441,
      1.228495,
      5,
      '10- 4-1979',
      45,
      1.382376,
      ' 0-19-2002',
      6.111582,
      3,
      ' 1-25-1978',
      NULL,
      ' 1-29-1998',
      20.626910,
      ' 7-12-2002',
      12,
      13.078993,
      ' 7-20-1995',
      57,
      79.312239,
      NULL,
      6,
      NULL,
      ' 8-27-1974',
      0.425857,
      0.899766,
      ' 5- 8-1999',
      2,
      3,
      13.386561,
      NULL,
      64,
      18,
      3,
      ' 9-14-1984',
      0.886206,
      0.161150,
      '11-11-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


