set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8335020';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0024',
      '40223322',
      '34412303',
      '04242232',
      '32304443',
      '01413113',
      '01213403',
      '00421400',
      '01432301',
      '31112210',
      '21232031',
      '32310342',
      '41104114',
      '02221303',
      '33123311',
      '40143414',
      '21411401',
      '21440332',
      '34224023',
      '41024242',
      '13141144',
      '14323303',
      '02003222',
      '10221414',
      NULL,
      '01314414',
      '43401044',
      '31210120',
      '22330022',
      '30020220',
      '22323320',
      NULL,
      '44341321',
      '44441224',
      '03434200',
      '12441331',
      '33130234',
      '23031041',
      '43404443',
      NULL,
      '02440340',
      '04131041',
      '33233334',
      '31231200',
      '32000430',
      NULL,
      '',
      NULL,
      NULL,
      '2103131',
      3,
      0,
      NULL,
      NULL,
      '004042',
      1.543716,
      '10-13-1982',
      ' 9- 9-1997',
      94,
      NULL,
      1.932269,
      3.036029,
      NULL,
      10,
      NULL,
      15.639521,
      9,
      13,
      NULL,
      10,
      10,
      7,
      5.811772,
      NULL,
      1.230482,
      0.742255,
      NULL,
      NULL,
      36.442459,
      3,
      5,
      10.253719,
      NULL,
      61.490491,
      87.678750,
      33,
      147,
      130.498166,
      128,
      '11-27-1984',
      20,
      42,
      19.000262,
      29,
      74.659730,
      181,
      ' 8-19-2000',
      0.409206,
      1,
      0,
      0.346045,
      NULL,
      NULL,
      NULL,
      NULL,
      0.376629,
      NULL,
      1.665543,
      1,
      0.095215,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      100.189882,
      80.362020,
      85.976857,
      NULL,
      33.460135,
      NULL,
      12,
      75,
      14,
      72,
      3.099335,
      51.858714,
      '10- 2-1978',
      NULL,
      6,
      11,
      9,
      78.331709,
      13.159020,
      NULL,
      ' 2-15-1989',
      6.781339,
      1,
      ' 0-24-1996',
      1.808926,
      8,
      0,
      NULL,
      6,
      2.411528,
      NULL,
      4.366632,
      NULL,
      NULL,
      3.505951,
      1.622773,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-21-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      11.043070,
      2.507833,
      ' 9- 1-1985',
      1.684949,
      65.549894,
      ' 3- 7-1982',
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      36.226505,
      0.308288,
      91,
      ' 9- 6-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.111840,
      70,
      56,
      88,
      NULL,
      0,
      NULL,
      16.236416,
      1,
      54,
      1,
      0.900401,
      18,
      NULL,
      NULL,
      39.909842,
      0,
      NULL,
      2,
      NULL,
      1,
      87.898728,
      38.714402,
      7.444747,
      NULL,
      0,
      9,
      NULL,
      NULL,
      1,
      1,
      1,
      1.051218,
      2.051312,
      75,
      81,
      NULL,
      41,
      NULL,
      0,
      0.397597,
      35.913380,
      0.021295,
      3,
      1.514921,
      11.742729,
      0.024425,
      32.441828,
      5,
      86,
      0.380392,
      0,
      NULL,
      NULL,
      0.096048,
      0.052223,
      51,
      NULL,
      NULL,
      12.702314,
      NULL,
      2.138720,
      NULL,
      9,
      1.809693,
      NULL,
      1.595539,
      3.435564,
      23.113161,
      ' 1-10-1988',
      '11-27-1985',
      ' 5-26-2002',
      ' 1-10-1999',
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


