set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9728606';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '2',
      NULL,
      '1',
      NULL,
      '4',
      '4',
      '0',
      NULL,
      '2',
      NULL,
      '4',
      '0',
      '3',
      '0',
      '1',
      '1',
      '4',
      '3',
      '1',
      NULL,
      NULL,
      '0',
      NULL,
      '',
      '2',
      '',
      '3',
      '0',
      NULL,
      '3',
      '0',
      '',
      '',
      '3',
      '4',
      '4',
      '2',
      '0',
      '0',
      '4',
      NULL,
      '2',
      '0',
      '2',
      '012',
      '10143323',
      NULL,
      78.044344,
      '1222433',
      0,
      NULL,
      NULL,
      1,
      NULL,
      3.288037,
      ' 8- 8-1984',
      ' 5-18-2000',
      3,
      94,
      52.472190,
      8.836733,
      16,
      21.434682,
      68.933584,
      1,
      22.240566,
      6.333692,
      NULL,
      19.070681,
      NULL,
      NULL,
      37.017999,
      12,
      26,
      22.254222,
      77,
      12.987647,
      25,
      NULL,
      112.034593,
      19.320678,
      1,
      32.552931,
      13,
      16,
      123.368506,
      6.561004,
      175,
      ' 0-25-1997',
      29,
      47.113886,
      NULL,
      37.825112,
      211.403604,
      196.421898,
      ' 6-26-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12,
      4,
      17,
      6.951988,
      NULL,
      ' 0-10-1983',
      0,
      0.832173,
      118,
      0.726281,
      1.233439,
      4,
      NULL,
      0.853047,
      75,
      NULL,
      NULL,
      NULL,
      ' 5-29-1981',
      1.779227,
      53,
      39.218241,
      77,
      NULL,
      116.034102,
      92.808814,
      16.538294,
      43,
      4,
      30.457715,
      NULL,
      ' 2-19-1977',
      38,
      NULL,
      22,
      8.040424,
      25,
      170.378317,
      11.479196,
      NULL,
      37,
      25.982835,
      ' 9- 8-1985',
      12.120477,
      16.068808,
      6,
      18.505936,
      8.857939,
      12,
      1,
      9,
      NULL,
      NULL,
      3.366480,
      0.332470,
      12.687212,
      19,
      4,
      1.740934,
      3,
      NULL,
      ' 0-27-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      231.247899,
      2.228573,
      ' 6-26-2003',
      NULL,
      NULL,
      NULL,
      2.339151,
      ' 7- 6-1983',
      39,
      ' 0-22-1974',
      3.898644,
      11,
      ' 9-13-1988',
      27,
      31,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      18.334439,
      '10-14-1979',
      3,
      NULL,
      21.429932,
      '11-21-1975',
      1,
      NULL,
      ' 1-22-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


