set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9528893';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4400',
      '44430333',
      '33420210',
      '41323221',
      '42132330',
      '14302430',
      NULL,
      '30221442',
      '22133011',
      '22200043',
      '22310413',
      '33020321',
      '24131421',
      '33414010',
      '34012221',
      NULL,
      '01214433',
      NULL,
      '31010140',
      NULL,
      '12300001',
      NULL,
      '02430411',
      '34142202',
      '01322223',
      NULL,
      '10102342',
      NULL,
      '41422231',
      '43113343',
      '03411232',
      '11302424',
      NULL,
      NULL,
      '33322143',
      '03021002',
      '33412134',
      '32113444',
      '44304320',
      '13322244',
      '32124001',
      '00141303',
      '24133200',
      '33234011',
      '04012414',
      NULL,
      '41',
      NULL,
      NULL,
      '1310432',
      0.724528,
      1,
      2,
      NULL,
      '111040',
      3.190749,
      ' 0- 0-1998',
      ' 0-13-1983',
      NULL,
      NULL,
      8,
      NULL,
      21,
      NULL,
      18,
      11.003105,
      13,
      4.912141,
      NULL,
      NULL,
      35.127915,
      5,
      30,
      2,
      NULL,
      23.103640,
      27.165212,
      8,
      NULL,
      5,
      NULL,
      4,
      0.665182,
      NULL,
      NULL,
      NULL,
      NULL,
      106.257463,
      103,
      ' 6-28-1981',
      19,
      21.010939,
      0.639856,
      12.596189,
      34,
      174.522506,
      NULL,
      NULL,
      0,
      0,
      5,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.221344,
      1,
      1,
      1,
      5,
      0.393812,
      0.514945,
      3.047480,
      0.017092,
      0.529220,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-21-1976',
      NULL,
      3.437265,
      2,
      3.149157,
      0.444362,
      6.671466,
      ' 5-20-1992',
      0,
      0.384317,
      7.088297,
      0,
      1.109923,
      42.874818,
      1.878188,
      7,
      7.758619,
      NULL,
      NULL,
      NULL,
      ' 9-19-1976',
      79,
      41.400597,
      NULL,
      NULL,
      43.986340,
      81.563877,
      21,
      9,
      32.373602,
      52.929136,
      22,
      44,
      ' 7-24-2003',
      4,
      11.042544,
      7.929838,
      25,
      4.043114,
      NULL,
      9,
      ' 2-24-1988',
      19,
      6,
      ' 0-26-2001',
      1,
      1.253952,
      1.286790,
      NULL,
      15.211941,
      7,
      0,
      3.838360,
      0.124160,
      91,
      1.605948,
      7,
      2,
      NULL,
      NULL,
      3.154001,
      1.155308,
      NULL,
      ' 0-27-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      80,
      22,
      '10- 2-1986',
      NULL,
      NULL,
      NULL,
      8,
      ' 1-12-2002',
      30.923040,
      ' 9-23-1998',
      0.689416,
      NULL,
      ' 4-15-1988',
      NULL,
      NULL,
      NULL,
      3.463274,
      1,
      ' 0-17-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      56.262505,
      5.329713,
      22.430509,
      '10-13-1982',
      NULL,
      109.126353,
      ' 9- 3-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


