set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '3292370';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '3',
      NULL,
      '3',
      NULL,
      '2',
      '2',
      NULL,
      '1',
      '1',
      '0',
      NULL,
      '4',
      '0',
      '0',
      NULL,
      '0',
      '2',
      '1',
      '4',
      '4',
      '1',
      '3',
      '3',
      '',
      '0',
      '',
      '2',
      NULL,
      '2',
      NULL,
      '1',
      NULL,
      '',
      '0',
      '1',
      '2',
      '4',
      '2',
      '0',
      '4',
      '1',
      '2',
      NULL,
      '3',
      '023',
      '32434311',
      44.742389,
      2.740504,
      '1212243',
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      ' 8- 1-1988',
      47.988750,
      6,
      NULL,
      18.417625,
      0.478228,
      7.161809,
      118.129379,
      14,
      15.456266,
      3.001344,
      NULL,
      27,
      24.552753,
      9.026288,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.168545,
      NULL,
      6,
      8,
      NULL,
      0,
      NULL,
      9,
      122.406975,
      83.789313,
      232,
      63,
      ' 7-29-1976',
      54,
      34,
      7.180514,
      12.305326,
      19,
      78,
      ' 3-28-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      9.090128,
      NULL,
      9,
      9,
      ' 3-15-1982',
      NULL,
      7.376035,
      NULL,
      0.893834,
      0.751774,
      NULL,
      1.461361,
      0.081586,
      0.129239,
      NULL,
      NULL,
      NULL,
      ' 0- 3-2003',
      71.452065,
      NULL,
      53.468368,
      107.282708,
      101,
      NULL,
      45.751170,
      103,
      9.857453,
      23.301490,
      104,
      86.856857,
      ' 4- 3-1998',
      8,
      35.707407,
      27,
      23.712113,
      NULL,
      133.085641,
      NULL,
      ' 6-29-1975',
      NULL,
      5,
      ' 7-19-1981',
      9,
      10,
      31,
      23,
      13.135859,
      1,
      1.827815,
      1.474716,
      NULL,
      53,
      1,
      7,
      NULL,
      2.819356,
      1.291725,
      NULL,
      1,
      0.796780,
      ' 3-29-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-20-1987',
      NULL,
      NULL,
      NULL,
      58,
      ' 8- 0-1998',
      7.712765,
      ' 8-22-1997',
      2,
      3.035598,
      ' 5- 8-1999',
      NULL,
      15,
      ' 8-22-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      5,
      ' 9- 2-2002',
      19.842986,
      46.573605,
      NULL,
      ' 1- 6-1985',
      1,
      5.045099,
      ' 7- 1-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


