set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7128938';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0404',
      '24113344',
      '24023411',
      '23442213',
      '24331231',
      '44420030',
      '10341330',
      '31143041',
      '24032112',
      '33103121',
      '31241112',
      '33320140',
      NULL,
      '34420220',
      '03024104',
      NULL,
      '13114100',
      '40344304',
      '43044232',
      '14142024',
      '42213413',
      '40002202',
      '00141310',
      '30413112',
      '04400243',
      '14430141',
      NULL,
      '40130201',
      '03214223',
      '12040214',
      '23311231',
      '03411124',
      '44220043',
      '14133114',
      NULL,
      '43122324',
      NULL,
      '04000301',
      '32301013',
      NULL,
      '14321434',
      '02204011',
      NULL,
      '24034304',
      '01332112',
      '034',
      '20',
      30,
      NULL,
      '4221343',
      3.983290,
      0.443157,
      3,
      NULL,
      '041224',
      NULL,
      ' 0- 4-1979',
      ' 2-28-1974',
      26,
      89,
      34.959482,
      9,
      35.159911,
      19,
      7,
      NULL,
      6,
      NULL,
      13.771005,
      9.834825,
      9,
      11,
      10,
      11,
      5.964371,
      11.068427,
      15,
      NULL,
      7,
      7,
      21.205428,
      6.360118,
      1.295230,
      12,
      85,
      37,
      96,
      16,
      123.555983,
      '11- 9-1999',
      NULL,
      8,
      3,
      NULL,
      43,
      99,
      ' 9-25-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      83,
      0.965081,
      NULL,
      31.580681,
      0.346844,
      0.126614,
      27.957207,
      NULL,
      NULL,
      NULL,
      ' 2-15-1990',
      36,
      40.975862,
      55,
      64.096248,
      70,
      41.214084,
      37,
      11,
      7,
      46.980240,
      54,
      86.149073,
      NULL,
      21.376476,
      30,
      NULL,
      22.723540,
      62.573689,
      NULL,
      11.042832,
      ' 5-21-1977',
      18.498688,
      NULL,
      NULL,
      6.468152,
      12.029765,
      13.962552,
      2.307264,
      3,
      NULL,
      1.018780,
      4,
      0,
      NULL,
      11,
      1.496172,
      2,
      26.786613,
      1,
      19,
      9.356632,
      12,
      '10- 4-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      15.812509,
      0.817971,
      ' 8-24-1999',
      NULL,
      NULL,
      NULL,
      31,
      '10-16-1987',
      19.988372,
      ' 1- 8-1981',
      1.201302,
      12.328563,
      ' 9- 0-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      19.759122,
      ' 6-23-2001',
      36.282052,
      5,
      4,
      ' 9-10-2000',
      3.866214,
      NULL,
      ' 6- 5-1983',
      NULL,
      75,
      17.242090,
      NULL,
      ' 5- 7-1992',
      NULL,
      1.935933,
      43,
      '10-24-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


