set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8813791';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4021',
      '42242400',
      '02032212',
      NULL,
      '21300422',
      '11313313',
      '34430433',
      '43031440',
      '24012323',
      '42010132',
      NULL,
      '33134421',
      NULL,
      '43313433',
      NULL,
      '02321011',
      '14321110',
      NULL,
      '10231342',
      '43104400',
      NULL,
      NULL,
      '02322203',
      '14144031',
      '31423414',
      '34342124',
      '40404104',
      '00434100',
      '11313431',
      '21004440',
      '44412401',
      NULL,
      NULL,
      '11201123',
      NULL,
      NULL,
      '23404240',
      '21323203',
      '34113411',
      '14040140',
      '23231112',
      '00012113',
      NULL,
      '10421312',
      NULL,
      '',
      '',
      NULL,
      NULL,
      '0143400',
      0.118822,
      1.760694,
      NULL,
      NULL,
      '240100',
      2.705145,
      ' 9- 4-1994',
      ' 6- 3-2000',
      5.236610,
      NULL,
      NULL,
      0.506291,
      10.397858,
      2.507779,
      62.285787,
      15.154869,
      9,
      6,
      NULL,
      NULL,
      1,
      5.609424,
      31,
      9.952449,
      4.281468,
      7,
      40,
      6,
      40,
      3.264649,
      NULL,
      8,
      NULL,
      NULL,
      40.876580,
      67.441668,
      36,
      21,
      27.739988,
      NULL,
      53.982662,
      7,
      NULL,
      10,
      46.648831,
      6,
      ' 5- 5-1997',
      4.245927,
      5,
      1.966376,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.998805,
      0.473906,
      9,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-14-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 9-1984',
      28,
      43.250980,
      57,
      36,
      32,
      40,
      71,
      74,
      63,
      NULL,
      7.825629,
      4,
      NULL,
      11.561624,
      0,
      7,
      3.584998,
      17.479463,
      0,
      1,
      ' 5- 7-1974',
      1.130097,
      0.739648,
      ' 8- 2-1999',
      6.683288,
      6.678020,
      9,
      7,
      11.027457,
      2,
      NULL,
      NULL,
      NULL,
      14.772037,
      4,
      0,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      19,
      30,
      ' 3-17-1974',
      0,
      78,
      ' 7-23-1987',
      15,
      NULL,
      1,
      NULL,
      ' 6- 6-1987',
      18,
      1.057055,
      NULL,
      ' 0-12-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      89.501862,
      14,
      56,
      NULL,
      96,
      3,
      2.927300,
      17,
      6.453258,
      11,
      13.291541,
      0.711154,
      5,
      144.954574,
      4.107592,
      0.679188,
      114,
      0.172406,
      4,
      NULL,
      NULL,
      1,
      NULL,
      9,
      25,
      NULL,
      1,
      77.345146,
      1.019872,
      0,
      0,
      0,
      1,
      1,
      NULL,
      7.626709,
      NULL,
      NULL,
      18.087007,
      NULL,
      5.927954,
      0,
      25.025227,
      0.041647,
      NULL,
      3,
      8,
      NULL,
      41.877460,
      0.353270,
      9.304593,
      NULL,
      0.771912,
      NULL,
      NULL,
      NULL,
      7.208468,
      23,
      NULL,
      3,
      58.777129,
      NULL,
      6,
      1.947741,
      8.677427,
      0.163143,
      0.745199,
      NULL,
      0,
      60,
      ' 9-27-1979',
      ' 4-18-1981',
      ' 7-10-1999',
      ' 0-27-1975',
      NULL,
      NULL,
      ' 5- 2-1984',
      NULL);
commit;
end;
/


