set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8813791';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1304',
      NULL,
      '10034044',
      '44412342',
      '30330423',
      '02221204',
      NULL,
      '00020304',
      '41121441',
      '22210301',
      NULL,
      '13021344',
      '03434024',
      '13234103',
      NULL,
      NULL,
      '43222041',
      '14341023',
      '44422124',
      '01433042',
      '22340030',
      '10421332',
      NULL,
      '13104442',
      '32123443',
      '10320033',
      '30221112',
      NULL,
      NULL,
      '34341220',
      '20322334',
      '03024114',
      '42103410',
      '23334334',
      '33243232',
      '20044104',
      '34121002',
      '33334311',
      '40140401',
      '43442433',
      '21433043',
      '12312101',
      NULL,
      '20330120',
      '03112103',
      '',
      '',
      NULL,
      NULL,
      NULL,
      2,
      21.676371,
      3,
      NULL,
      '202140',
      1.932907,
      ' 5-12-2003',
      '11-28-2001',
      50,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      44,
      9,
      2.598163,
      11.104465,
      3.240218,
      NULL,
      NULL,
      0.911633,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.084301,
      0,
      3,
      1,
      1,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 4-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 1-1976',
      42,
      NULL,
      79,
      34.794934,
      NULL,
      67.371057,
      8,
      65.076166,
      9,
      71.795105,
      20,
      73,
      ' 3-24-2002',
      NULL,
      10,
      NULL,
      NULL,
      38,
      52.057753,
      NULL,
      ' 1-25-1974',
      5,
      0.840219,
      ' 9-17-1980',
      3,
      12,
      1,
      3.948959,
      NULL,
      5.228167,
      NULL,
      NULL,
      NULL,
      47.652021,
      1.901634,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-17-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.094712,
      15,
      ' 9-12-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      110.344027,
      65.462455,
      0,
      116.396541,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      19.331020,
      NULL,
      1.240262,
      NULL,
      NULL,
      3.030849,
      74,
      1.159685,
      0.017773,
      142.189149,
      72,
      NULL,
      NULL,
      1.255768,
      66,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      104,
      NULL,
      NULL,
      NULL,
      94,
      NULL,
      0.135698,
      1.956353,
      1,
      7.978227,
      0,
      17,
      NULL,
      25,
      1.719633,
      82,
      NULL,
      0,
      98.992143,
      NULL,
      NULL,
      3,
      2,
      NULL,
      NULL,
      NULL,
      6,
      9.990813,
      1,
      8,
      5.231494,
      NULL,
      0.819059,
      4.325741,
      101.867564,
      NULL,
      NULL,
      NULL,
      ' 8-27-1974',
      ' 3- 5-1994',
      NULL,
      ' 8-24-1979',
      NULL);
commit;
end;
/


