set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8813791';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0114',
      '01444102',
      NULL,
      '12413010',
      '20343312',
      '02321133',
      '03443404',
      '14244233',
      '44443341',
      '14323433',
      NULL,
      '44033311',
      NULL,
      NULL,
      '14344440',
      '30024434',
      '03433411',
      '11210411',
      '21340202',
      '12103244',
      '30313223',
      '11444220',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '00441121',
      NULL,
      '03240342',
      '22013332',
      '24413001',
      '00343400',
      '12242122',
      '43004324',
      NULL,
      '40221434',
      '34222121',
      '33440223',
      '00043312',
      '04331244',
      '34001201',
      '34301422',
      '00040042',
      '200',
      '12',
      NULL,
      NULL,
      '4224344',
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      ' 9-14-2001',
      ' 2-15-1989',
      NULL,
      NULL,
      23,
      1,
      1,
      NULL,
      35.407382,
      NULL,
      1,
      12,
      NULL,
      9,
      13,
      7,
      NULL,
      9.393573,
      15,
      10,
      19,
      4,
      2,
      NULL,
      65.080018,
      NULL,
      2.317930,
      68,
      118.445586,
      31.167177,
      24,
      81.905578,
      NULL,
      ' 4-10-1982',
      45,
      9.529061,
      17,
      NULL,
      64.709407,
      3.604443,
      '10-11-1993',
      6,
      NULL,
      4.108982,
      NULL,
      9.232886,
      3,
      0.124705,
      NULL,
      0,
      0,
      1.622655,
      1,
      1,
      2,
      1,
      NULL,
      NULL,
      0.440209,
      1.886594,
      3.824576,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 1-1979',
      71,
      13.519120,
      5,
      0,
      12.180976,
      NULL,
      ' 5-28-1975',
      1.760449,
      1,
      135,
      0.701056,
      1,
      25.702476,
      NULL,
      NULL,
      19,
      NULL,
      NULL,
      NULL,
      ' 2- 9-1987',
      73.984894,
      63.627151,
      102,
      61,
      38.553979,
      NULL,
      66.622785,
      22.669013,
      67.056980,
      25.385006,
      2.719866,
      83,
      ' 5- 0-2003',
      2,
      0,
      NULL,
      15,
      26.039179,
      5.262749,
      7,
      ' 7-11-1987',
      1,
      0.720759,
      ' 2-26-1975',
      NULL,
      3,
      NULL,
      7,
      0,
      NULL,
      0,
      1,
      0,
      10.620193,
      NULL,
      1,
      2.673204,
      3.104846,
      18.776118,
      3,
      NULL,
      1,
      ' 3-26-1992',
      0.917508,
      1,
      0.544177,
      ' 9-16-1982',
      NULL,
      14.873339,
      ' 5- 3-1982',
      NULL,
      NULL,
      NULL,
      24.006132,
      ' 3- 8-1986',
      40,
      '11- 6-1976',
      10.519277,
      NULL,
      ' 8- 0-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      3.824006,
      ' 9-16-1977',
      NULL,
      NULL,
      NULL,
      3,
      1,
      3,
      ' 6-10-1994',
      52.591534,
      3,
      2.344640,
      NULL,
      7.801879,
      346,
      ' 3- 7-1985',
      7.216980,
      74.893862,
      13,
      NULL,
      ' 9- 0-1981',
      NULL,
      0,
      82.145392,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5);
commit;
end;
/


