set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8813791';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '0',
      '4',
      '0',
      '3',
      '2',
      '4',
      NULL,
      '3',
      NULL,
      '1',
      '1',
      '1',
      NULL,
      '4',
      '1',
      '4',
      '4',
      '2',
      '1',
      '0',
      '3',
      NULL,
      NULL,
      '',
      '2',
      '',
      NULL,
      '2',
      '3',
      '1',
      '4',
      '',
      '',
      NULL,
      '2',
      '3',
      NULL,
      '4',
      '1',
      NULL,
      '4',
      '4',
      '0',
      '2',
      NULL,
      NULL,
      58.116031,
      NULL,
      '4330220',
      NULL,
      223.870643,
      1,
      NULL,
      '101234',
      5,
      ' 6- 0-1975',
      ' 0-10-1982',
      225,
      16.952598,
      2,
      4,
      0.844323,
      4,
      25.943248,
      NULL,
      0.388606,
      7.422810,
      3.911821,
      4,
      NULL,
      7.354371,
      17.392201,
      13.986940,
      8,
      11.977414,
      NULL,
      19.336406,
      50.088322,
      10,
      40,
      NULL,
      1.445300,
      8,
      NULL,
      10.252805,
      127,
      87.950937,
      105.456487,
      ' 3-18-1977',
      39,
      10.336231,
      23,
      NULL,
      41.569180,
      NULL,
      ' 9- 0-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      22,
      NULL,
      7.974654,
      NULL,
      0.188020,
      NULL,
      '10-20-2003',
      1.773983,
      1,
      16,
      2.071786,
      3.843195,
      9,
      1,
      0,
      50.272619,
      NULL,
      NULL,
      NULL,
      ' 6-22-1980',
      62.301955,
      NULL,
      NULL,
      69.928362,
      98,
      15,
      39.588762,
      4.609326,
      56.560004,
      28,
      84.647287,
      62,
      ' 0-22-1999',
      7.946244,
      4,
      5.367625,
      5,
      NULL,
      NULL,
      0,
      ' 9- 2-1982',
      6,
      2.336000,
      ' 0-14-1975',
      3,
      9,
      1,
      0.824447,
      10,
      3,
      2,
      0.498675,
      1,
      12,
      6.205962,
      1,
      NULL,
      5,
      1,
      1,
      NULL,
      1,
      ' 4-13-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.154675,
      ' 0-28-1977',
      3,
      NULL,
      4.228356,
      1,
      ' 1-27-1992',
      30.057003,
      42.742434,
      ' 7- 0-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      8,
      ' 2- 2-1983',
      NULL,
      17.872257,
      23.229422,
      '10- 5-1981',
      1,
      143.721097,
      ' 4- 3-2001',
      7.770371,
      21,
      1,
      NULL,
      ' 0-16-1990',
      NULL,
      1,
      183,
      ' 8- 1-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


