set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9515594';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '1',
      NULL,
      '1',
      '3',
      '4',
      '4',
      '1',
      '2',
      '1',
      '4',
      '2',
      '4',
      '0',
      '2',
      '1',
      '0',
      '0',
      '4',
      '4',
      '0',
      '4',
      '3',
      '3',
      '',
      NULL,
      '',
      '4',
      '4',
      '4',
      NULL,
      '4',
      '',
      '',
      NULL,
      NULL,
      '1',
      '4',
      NULL,
      '1',
      '4',
      NULL,
      NULL,
      '0',
      '3',
      '311',
      '32000204',
      9.061722,
      21,
      '1001400',
      0,
      0.721316,
      0,
      NULL,
      '113441',
      1,
      ' 7-17-1995',
      NULL,
      39,
      203,
      0.141870,
      NULL,
      NULL,
      18,
      NULL,
      NULL,
      23.922518,
      21.124119,
      14.361299,
      4.418708,
      NULL,
      18.184940,
      NULL,
      17,
      10,
      9,
      81,
      4.012550,
      37,
      NULL,
      91,
      25,
      0,
      NULL,
      3,
      37,
      8.233979,
      96,
      58,
      ' 4-22-1991',
      15.762358,
      29.201084,
      NULL,
      NULL,
      37.981608,
      154.429609,
      ' 1- 3-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      28.286762,
      11,
      13.378583,
      10,
      1.022501,
      ' 8-26-1979',
      NULL,
      0.929472,
      252,
      1,
      1.279863,
      12.498576,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-29-1988',
      NULL,
      28.983654,
      91.623136,
      NULL,
      79.535857,
      58,
      31,
      58,
      NULL,
      51.075133,
      80,
      51,
      '10- 4-1994',
      12.800029,
      0.113126,
      9,
      13.332397,
      NULL,
      19.051914,
      10.282083,
      '11-24-1993',
      14.236295,
      NULL,
      ' 0- 8-1975',
      8,
      13,
      21,
      NULL,
      13,
      6.642118,
      0,
      14,
      1.184380,
      2.478820,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.717415,
      1.581643,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      37,
      19.050653,
      ' 9-13-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 0-1991',
      23,
      ' 7-26-1997',
      10,
      NULL,
      ' 1-13-1985',
      44.974096,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      12,
      ' 4-19-1984',
      2.224180,
      22,
      NULL,
      NULL,
      NULL,
      63,
      ' 1- 0-1982',
      5.203847,
      9.443212,
      7.290672,
      8,
      ' 2-17-1998',
      0.779278,
      NULL,
      95,
      ' 1-28-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


