set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9023826';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '00144012',
      NULL,
      '41220421',
      '23414411',
      NULL,
      '34103120',
      NULL,
      NULL,
      NULL,
      NULL,
      '00410122',
      NULL,
      '11120141',
      '33100201',
      '44434404',
      '42022210',
      '04403311',
      '22034032',
      '32133234',
      '32342000',
      '11122232',
      NULL,
      NULL,
      '30132100',
      '02202400',
      '44411333',
      '04201043',
      '13032211',
      '12204022',
      '00411114',
      '33114100',
      '31420331',
      NULL,
      '30031422',
      '30004240',
      '14032220',
      NULL,
      '02321220',
      '13233223',
      '33001240',
      NULL,
      NULL,
      '20221021',
      NULL,
      '311',
      NULL,
      NULL,
      NULL,
      '1241432',
      1.648203,
      0,
      3,
      NULL,
      '310242',
      1.205417,
      ' 5- 3-1975',
      ' 7-12-1980',
      36.782493,
      NULL,
      9.964521,
      3,
      4.678001,
      16.930842,
      13.448706,
      12,
      15.996133,
      10,
      23.967933,
      21,
      14.032973,
      7.783207,
      NULL,
      NULL,
      6.609146,
      7,
      31.042327,
      3.986224,
      61,
      6,
      NULL,
      NULL,
      NULL,
      104,
      12,
      18,
      NULL,
      166.034033,
      123,
      NULL,
      1.875471,
      57.687625,
      4,
      1,
      54.607433,
      137,
      ' 4-29-1975',
      1.849154,
      1.125934,
      1.236359,
      1.819715,
      1,
      NULL,
      1,
      1,
      1.725481,
      NULL,
      0,
      0.863662,
      1.183878,
      0.969367,
      NULL,
      1,
      0.478213,
      1.145763,
      0,
      1.682198,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-16-1978',
      34,
      5,
      6.476382,
      4.955344,
      4.365545,
      7.414479,
      '10- 1-1984',
      1,
      1.830306,
      114,
      1.619811,
      2.441516,
      51.808114,
      1.391275,
      3,
      22,
      1,
      0,
      26,
      ' 6-15-2001',
      131,
      102.033268,
      109,
      67,
      101,
      27,
      17,
      97,
      NULL,
      NULL,
      NULL,
      117,
      ' 4- 6-1996',
      12,
      24,
      8.660406,
      36,
      NULL,
      0.964901,
      4,
      '10-13-1988',
      10.140234,
      5.725543,
      ' 8-10-1974',
      15.530277,
      10.480984,
      1.900783,
      6.983818,
      1,
      NULL,
      0.591893,
      NULL,
      0,
      NULL,
      0.707597,
      NULL,
      2.677206,
      18,
      1.445225,
      5,
      1,
      1,
      NULL,
      0.294322,
      1.831939,
      2,
      ' 8-10-2003',
      NULL,
      1.506060,
      '11-14-1980',
      14,
      NULL,
      ' 3-16-1990',
      9,
      NULL,
      22.663538,
      ' 6- 5-2002',
      6,
      9.004311,
      ' 7-19-1976',
      NULL,
      NULL,
      NULL,
      4.117678,
      1.021341,
      '10-19-1976',
      4,
      0.051893,
      ' 1-23-1996',
      2,
      2,
      NULL,
      '10-28-1994',
      NULL,
      33.535361,
      38.047487,
      ' 6- 8-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5);
commit;
end;
/


