set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8924136';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4220',
      '11400104',
      '22213120',
      '20024412',
      '01213131',
      '40001302',
      NULL,
      '30041101',
      '02312104',
      NULL,
      '40440014',
      '00110001',
      '34403401',
      '12122121',
      '43140414',
      '10421044',
      '33320324',
      '30210303',
      '20122202',
      NULL,
      '24224130',
      NULL,
      NULL,
      '33124043',
      '21301201',
      '44414423',
      NULL,
      '30134314',
      '22010202',
      '31222243',
      '44040200',
      '21331141',
      '01024032',
      '14220014',
      '33002024',
      NULL,
      '34301123',
      NULL,
      '23403240',
      '00332234',
      NULL,
      '31404131',
      '31134443',
      NULL,
      '42121011',
      '',
      NULL,
      NULL,
      NULL,
      '1320403',
      1.411381,
      0.282057,
      3,
      NULL,
      NULL,
      2.026189,
      ' 1-21-1979',
      ' 0- 2-1994',
      9.743438,
      NULL,
      35,
      23.956240,
      29.159692,
      16.539394,
      84.813694,
      21,
      8,
      18,
      16.402638,
      4.239932,
      33.133760,
      NULL,
      NULL,
      15.806279,
      37,
      20.457099,
      49.044688,
      30,
      16,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      192.138597,
      74,
      52,
      ' 5-10-1988',
      64,
      65.328631,
      9,
      30,
      76.528835,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-14-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      24,
      3.582048,
      NULL,
      NULL,
      115,
      3.881096,
      '10-27-2003',
      3,
      4.632032,
      ' 4- 1-1988',
      6,
      7,
      3,
      2.669902,
      16.826091,
      1,
      NULL,
      5,
      NULL,
      80.845110,
      9.906324,
      0.369615,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-28-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      60,
      45.061900,
      0,
      ' 1-17-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      46.776812,
      1,
      69.745804,
      ' 3-10-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      47,
      NULL,
      30.185648,
      NULL,
      24.739297,
      2.005406,
      0.737591,
      39.887500,
      1.615932,
      0,
      26.736794,
      0.166482,
      0,
      50.517000,
      NULL,
      0,
      53,
      0.648649,
      NULL,
      51,
      NULL,
      NULL,
      66,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      42,
      7,
      NULL,
      3.188626,
      NULL,
      1,
      1.110105,
      0,
      18,
      1.224154,
      57,
      0.166847,
      NULL,
      0.610295,
      0,
      69.799133,
      16.951786,
      7,
      NULL,
      NULL,
      53.705371,
      9.282131,
      54,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-14-1978',
      ' 7-14-1987',
      ' 7-10-1981',
      ' 9-29-2000',
      ' 8-21-1985',
      ' 9- 6-1980',
      NULL,
      NULL);
commit;
end;
/


