set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9501739';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3130',
      '10340403',
      '30214233',
      '30410244',
      '41404324',
      '22001430',
      '43144123',
      '33322144',
      NULL,
      '23004424',
      '21444314',
      '43303214',
      '44112332',
      NULL,
      NULL,
      '44224031',
      '34412032',
      '43424144',
      '40014122',
      '01034130',
      '42320223',
      NULL,
      '30431030',
      NULL,
      NULL,
      '24133230',
      NULL,
      NULL,
      '23143200',
      '33200333',
      '43031001',
      '30304442',
      '40220201',
      '22134220',
      '12400241',
      '41132003',
      NULL,
      NULL,
      '44034004',
      NULL,
      '22010001',
      '20241332',
      '21114021',
      NULL,
      '34210434',
      '003',
      '23',
      NULL,
      NULL,
      '3123444',
      2.825609,
      0.471046,
      0,
      NULL,
      '331000',
      5.768655,
      ' 8-19-1988',
      NULL,
      72,
      NULL,
      41.758521,
      16.915382,
      3.131835,
      2.356455,
      36.790495,
      1.319248,
      7.584579,
      13,
      15.590716,
      8,
      1.025061,
      11.601266,
      2,
      NULL,
      NULL,
      NULL,
      5.511114,
      10,
      3.947217,
      10.470724,
      59,
      9.759120,
      0,
      42,
      61,
      35.741458,
      61.333566,
      NULL,
      55,
      ' 1-13-1982',
      38,
      NULL,
      14.186461,
      12.797986,
      8.278432,
      85,
      '10- 8-1986',
      4.261279,
      7,
      8.863150,
      5,
      8,
      1.117150,
      5,
      6,
      NULL,
      1.821195,
      5.212473,
      0.556088,
      0.696653,
      3.484998,
      1,
      1,
      5.737418,
      1.917055,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-17-1977',
      33,
      NULL,
      44,
      38.630950,
      NULL,
      0,
      '11-14-1989',
      0,
      0.118038,
      172,
      2.122591,
      2.212883,
      NULL,
      5,
      1.356348,
      36.138954,
      NULL,
      NULL,
      NULL,
      ' 0-28-1995',
      27.811721,
      NULL,
      56,
      NULL,
      45.804599,
      22,
      14.846196,
      NULL,
      0.310641,
      48.172041,
      25,
      NULL,
      ' 3-16-1990',
      NULL,
      3,
      20.831669,
      NULL,
      69.219887,
      56,
      5.190979,
      ' 5-28-1993',
      NULL,
      13.621880,
      '11- 3-2001',
      NULL,
      9,
      NULL,
      3.409474,
      20.570577,
      NULL,
      0,
      10,
      1,
      23,
      1.202857,
      1.321220,
      7.756915,
      NULL,
      NULL,
      1.972933,
      0,
      1.053739,
      ' 8- 7-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      4.114813,
      34,
      ' 8-25-1999',
      NULL,
      NULL,
      NULL,
      35,
      NULL,
      24.770896,
      ' 8- 1-1994',
      9.925239,
      NULL,
      ' 0-24-1985',
      41.636904,
      43.674892,
      ' 5-29-1996',
      13,
      10.729715,
      '10- 3-1985',
      NULL,
      NULL,
      NULL,
      3,
      2,
      16.566955,
      ' 4-28-1978',
      30.667217,
      2.037219,
      NULL,
      ' 1-20-1984',
      0,
      200,
      ' 6-18-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


