set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9127350';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0344',
      '41032220',
      '33413044',
      '00104323',
      '40333141',
      '11442001',
      NULL,
      '22444313',
      '43430234',
      '31030431',
      '31230212',
      '42304441',
      '03331343',
      '02034344',
      NULL,
      '43400240',
      NULL,
      '20131044',
      '34212240',
      '20223434',
      NULL,
      NULL,
      '02130302',
      '04030423',
      '10401304',
      NULL,
      '03000323',
      '10041222',
      '03220213',
      '13123130',
      '01230241',
      NULL,
      '44241440',
      '32012232',
      '23243001',
      '21002022',
      NULL,
      '14004403',
      NULL,
      '01340341',
      '14443142',
      NULL,
      '42012102',
      '21210414',
      '04004040',
      '023',
      '40',
      NULL,
      NULL,
      '1111411',
      NULL,
      0.272542,
      0,
      NULL,
      '301440',
      2.555172,
      ' 8-15-2003',
      ' 2-16-1978',
      14.757347,
      NULL,
      5.607588,
      22,
      5,
      NULL,
      32.351367,
      NULL,
      21,
      11.662707,
      34.845763,
      5,
      0.956098,
      4,
      19.021203,
      NULL,
      30,
      NULL,
      33,
      0,
      29,
      16.546238,
      NULL,
      NULL,
      0,
      7.025713,
      37.213498,
      25.192397,
      80.615295,
      32.495129,
      169,
      ' 6- 9-2003',
      48.647604,
      NULL,
      NULL,
      22.527120,
      NULL,
      0.919210,
      ' 9-18-1999',
      4.019547,
      1.253095,
      1.136737,
      NULL,
      1,
      1,
      2,
      0.857928,
      1.664312,
      0.793159,
      1.249510,
      0.067027,
      0,
      1,
      0.122827,
      0,
      1.184379,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 7-1983',
      80,
      2.696252,
      5.374565,
      0,
      9,
      6,
      NULL,
      1.884086,
      2.573384,
      34,
      1.261716,
      1.776568,
      116.040183,
      NULL,
      1.750820,
      87,
      NULL,
      1,
      45,
      ' 0-19-1977',
      30.504140,
      61.269143,
      80.401379,
      109.361168,
      12,
      56,
      33,
      NULL,
      36,
      45,
      NULL,
      21.947361,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      78.570537,
      21,
      NULL,
      ' 4- 8-1981',
      NULL,
      12.856940,
      '11-21-1977',
      9,
      4.401662,
      18.887040,
      10.256569,
      15.077435,
      NULL,
      0.081202,
      NULL,
      0,
      10,
      6.736085,
      15,
      3,
      22.393114,
      3.700017,
      9.091974,
      3.190372,
      NULL,
      ' 8-20-1993',
      4.510042,
      3.140277,
      3.406821,
      '11-20-1984',
      65.903944,
      6,
      ' 2-18-1997',
      50.388678,
      5.299712,
      '10-23-1977',
      NULL,
      ' 2-25-1985',
      18.338449,
      NULL,
      NULL,
      5,
      ' 9- 7-1976',
      8,
      77,
      ' 7- 1-1993',
      NULL,
      NULL,
      NULL,
      4.036399,
      12.422179,
      ' 6-21-1987',
      2,
      NULL,
      15.313293,
      ' 3-18-1977',
      NULL,
      18,
      17.435512,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13);
commit;
end;
/


