set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8709514';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '2',
      NULL,
      NULL,
      NULL,
      '3',
      '4',
      '2',
      '4',
      '1',
      '2',
      '4',
      NULL,
      '1',
      '2',
      NULL,
      '4',
      '1',
      '2',
      '2',
      '0',
      '3',
      '1',
      '4',
      '',
      '0',
      '',
      '4',
      '2',
      '1',
      '0',
      '4',
      '',
      '',
      '4',
      NULL,
      '3',
      NULL,
      '2',
      '4',
      '4',
      '3',
      '0',
      '0',
      '0',
      NULL,
      '12022123',
      19.788053,
      NULL,
      NULL,
      3.366708,
      1,
      2,
      NULL,
      '021010',
      0.599994,
      NULL,
      ' 2- 5-1988',
      13,
      73,
      NULL,
      15.420803,
      7.324720,
      15.427982,
      48.519941,
      20.910710,
      NULL,
      2.012178,
      47,
      NULL,
      11.173256,
      17.485656,
      7.818897,
      7.913008,
      NULL,
      7,
      17.518472,
      NULL,
      64.997573,
      14,
      164.686958,
      NULL,
      1.644118,
      12.041817,
      165,
      71.177442,
      204.048797,
      103,
      NULL,
      ' 5-11-2003',
      36,
      26,
      17,
      2,
      3,
      157.059670,
      ' 8-17-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      80.951210,
      NULL,
      8.376851,
      7.041049,
      NULL,
      1,
      ' 4-16-1982',
      1.422616,
      1,
      44.476306,
      0.427004,
      1.353250,
      49,
      3.055114,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      96.925728,
      115,
      NULL,
      90,
      121,
      75.098852,
      86.821383,
      71.445211,
      115,
      NULL,
      100.959464,
      35.627969,
      ' 3- 8-2003',
      NULL,
      4.131361,
      8,
      2,
      17.077914,
      71.392487,
      3,
      ' 1-25-1980',
      24.605048,
      10,
      ' 2-15-2003',
      2.267040,
      4,
      18.419052,
      NULL,
      1,
      11.792851,
      2.099991,
      10.893739,
      0.759160,
      47,
      0,
      6,
      7.402353,
      15.713360,
      5,
      NULL,
      0,
      1.092981,
      ' 2-24-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      199,
      6.581288,
      '10-15-1992',
      NULL,
      NULL,
      NULL,
      20.884393,
      ' 0-19-1989',
      26.388339,
      ' 7-21-1986',
      10.741240,
      4,
      ' 8-10-1987',
      128,
      123.298326,
      ' 9- 0-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      ' 5- 6-1989',
      30,
      30,
      14,
      NULL,
      1,
      73,
      ' 0-17-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


