set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9766478';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '2',
      '3',
      '4',
      '3',
      '4',
      '3',
      '3',
      '3',
      '1',
      '4',
      '0',
      '1',
      '4',
      '0',
      '0',
      '2',
      NULL,
      '',
      '3',
      '',
      '3',
      NULL,
      '0',
      '4',
      '2',
      '',
      '',
      '3',
      '1',
      NULL,
      '2',
      '3',
      NULL,
      '0',
      '4',
      '3',
      '2',
      '0',
      '433',
      '43024304',
      60.734442,
      NULL,
      '1344433',
      NULL,
      1.515055,
      0,
      NULL,
      '242033',
      4.566837,
      ' 0-29-1986',
      NULL,
      58.689781,
      NULL,
      NULL,
      4.264901,
      NULL,
      11,
      54,
      17,
      8.285315,
      5,
      NULL,
      16.129066,
      2.708770,
      NULL,
      15.962881,
      12,
      5.642071,
      11,
      24.389159,
      1,
      10.127545,
      5,
      82.505315,
      9,
      NULL,
      NULL,
      77,
      74,
      NULL,
      43.474248,
      NULL,
      '10-27-1979',
      33,
      NULL,
      13.567763,
      23,
      135.613874,
      48,
      ' 1-12-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13,
      1,
      10,
      2.734791,
      NULL,
      NULL,
      0,
      0.219108,
      123.809008,
      1,
      0.249487,
      NULL,
      1,
      1.298426,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-23-1980',
      67.397274,
      65,
      59,
      41.154609,
      35,
      67.802768,
      16.027445,
      62.633059,
      12,
      NULL,
      13.712391,
      43,
      ' 5-24-1992',
      9.746914,
      5.350292,
      4,
      10.460497,
      52,
      45,
      10,
      NULL,
      11.949174,
      3.829919,
      '10-29-1980',
      11,
      17.828445,
      15.213301,
      1,
      4,
      NULL,
      0.188542,
      3,
      1,
      11.307131,
      NULL,
      NULL,
      NULL,
      NULL,
      1.578865,
      14.730233,
      0.425327,
      1.823659,
      '11-17-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      83.045752,
      13,
      ' 6-16-1991',
      NULL,
      NULL,
      NULL,
      2.850967,
      ' 0-14-1978',
      20.936328,
      ' 2-13-1990',
      9,
      3.348964,
      ' 2-11-1975',
      10.456114,
      84.892600,
      ' 4-17-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      2.516363,
      ' 3-25-1996',
      69,
      34,
      29,
      ' 5-21-1979',
      2,
      NULL,
      '11- 6-1992',
      NULL,
      NULL,
      0,
      12.373019,
      ' 6- 1-1982',
      17.900411,
      1,
      43.731465,
      ' 2- 8-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


