set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9766478';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '2',
      '0',
      '1',
      '2',
      '0',
      '1',
      '2',
      '2',
      NULL,
      '3',
      '3',
      '1',
      '4',
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      '3',
      '2',
      '4',
      '0',
      '',
      '1',
      NULL,
      '2',
      '3',
      '3',
      NULL,
      '3',
      '',
      '',
      '1',
      '1',
      NULL,
      '3',
      '1',
      '4',
      '4',
      '2',
      '0',
      '0',
      NULL,
      NULL,
      '20423001',
      1.470451,
      42.276596,
      '0440413',
      3,
      9.235713,
      2,
      NULL,
      '411032',
      NULL,
      ' 9-17-1995',
      NULL,
      25,
      194.503395,
      NULL,
      NULL,
      21.218146,
      17,
      54,
      17,
      19.109069,
      NULL,
      5.686498,
      4.614794,
      NULL,
      NULL,
      18.968404,
      10,
      6,
      12.668827,
      NULL,
      3,
      11.709558,
      NULL,
      4,
      12,
      0.818063,
      NULL,
      170.327102,
      57,
      79.453327,
      31,
      NULL,
      ' 0-25-1982',
      41.587154,
      57.945477,
      28.881658,
      21.843411,
      NULL,
      142,
      ' 9-22-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16,
      19,
      36,
      NULL,
      7.923071,
      3,
      ' 1-22-1979',
      0.815523,
      3.114587,
      NULL,
      1,
      0,
      2.938913,
      1,
      1,
      47.462460,
      NULL,
      NULL,
      NULL,
      ' 2- 1-1974',
      17,
      NULL,
      2.956770,
      NULL,
      74,
      27.995751,
      NULL,
      NULL,
      55.356640,
      20.570140,
      1.957753,
      54,
      ' 2-25-1981',
      NULL,
      1.101049,
      NULL,
      6.715128,
      19,
      49,
      NULL,
      '11-29-1996',
      NULL,
      21,
      NULL,
      14.729756,
      NULL,
      10.326569,
      10,
      10.824442,
      NULL,
      NULL,
      3.451020,
      NULL,
      19.799543,
      0.609087,
      NULL,
      6,
      17.134108,
      0,
      4.055509,
      1.806765,
      0.419516,
      ' 1- 7-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      41.797831,
      16,
      ' 1-26-1980',
      NULL,
      NULL,
      NULL,
      7,
      ' 2-29-1980',
      36,
      ' 5-16-1990',
      3,
      NULL,
      ' 9-20-1975',
      126.419658,
      90.923799,
      ' 0-17-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      21.149318,
      ' 5-17-1994',
      14,
      23,
      NULL,
      ' 9- 0-2003',
      NULL,
      92,
      ' 0-26-1991',
      11.063784,
      16,
      NULL,
      29.985946,
      ' 8- 5-1996',
      61.169244,
      0,
      50,
      ' 0-22-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


