set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9970404';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '3',
      '0',
      NULL,
      '2',
      NULL,
      '1',
      '4',
      '4',
      '2',
      '0',
      '3',
      '1',
      '0',
      NULL,
      '1',
      NULL,
      '3',
      '4',
      '4',
      '3',
      '1',
      '1',
      '2',
      '',
      '4',
      '',
      NULL,
      '3',
      '4',
      NULL,
      NULL,
      '',
      '',
      '4',
      '0',
      '4',
      NULL,
      '2',
      '0',
      '0',
      NULL,
      '3',
      '0',
      '4',
      NULL,
      '22344013',
      31,
      76.542182,
      '2123431',
      1.503943,
      1.067537,
      0,
      0,
      '120204',
      1,
      NULL,
      ' 8-28-1983',
      108.701659,
      NULL,
      27,
      NULL,
      36,
      8,
      NULL,
      NULL,
      17,
      19,
      25,
      19.465000,
      NULL,
      NULL,
      NULL,
      6.680713,
      3,
      0,
      32,
      NULL,
      56.477267,
      7,
      103,
      9.090094,
      1,
      85,
      102,
      71,
      194,
      204.323969,
      159,
      ' 2-27-1991',
      NULL,
      62.810585,
      10,
      0,
      74.458200,
      NULL,
      '11- 2-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      18.041895,
      10.612601,
      11.915565,
      12,
      10.548881,
      7.360289,
      ' 1- 0-1996',
      1.568811,
      1,
      NULL,
      NULL,
      2,
      83,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-16-1974',
      34,
      67,
      NULL,
      NULL,
      65.050511,
      18,
      8,
      44,
      NULL,
      NULL,
      51.391744,
      74,
      ' 2- 0-1978',
      15.605870,
      NULL,
      10.332889,
      NULL,
      NULL,
      85,
      4,
      ' 4-13-1983',
      18,
      8,
      ' 9-28-1985',
      NULL,
      4.112416,
      7,
      11,
      8.179702,
      NULL,
      2,
      5,
      1,
      NULL,
      NULL,
      16.142726,
      18,
      21,
      1.846558,
      NULL,
      NULL,
      1.323175,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.647511,
      6,
      ' 3-13-1982',
      NULL,
      NULL,
      NULL,
      0.269542,
      ' 1-19-1977',
      10,
      NULL,
      7,
      13.012128,
      ' 8-10-1983',
      100.233929,
      31.779503,
      ' 8-12-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      6,
      ' 0- 2-1990',
      13,
      29.542830,
      25.134420,
      ' 2-12-1990',
      0,
      NULL,
      '11- 1-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


