set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9619680';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4420',
      '44042402',
      NULL,
      '03124032',
      '20031042',
      NULL,
      '00341322',
      '30021033',
      '13203441',
      '04100103',
      '31233424',
      '10310014',
      NULL,
      '44014310',
      '21103212',
      '41333300',
      '22221440',
      '41144440',
      '30113113',
      '24230430',
      '43343342',
      '14020310',
      '41220123',
      '23334043',
      '02312310',
      '40142222',
      NULL,
      '12140224',
      '42241311',
      '43313444',
      '31232330',
      '23200432',
      '01440440',
      '24221132',
      '33404122',
      '20201324',
      '11042402',
      '21313231',
      '10201344',
      '40333333',
      NULL,
      '10011232',
      NULL,
      '42030013',
      '34433123',
      '131',
      NULL,
      24,
      1,
      NULL,
      3.671155,
      1,
      NULL,
      NULL,
      '344332',
      5.817231,
      ' 2-12-2000',
      ' 3-14-1988',
      NULL,
      111.613857,
      23,
      20,
      13.800346,
      11,
      57.872269,
      20,
      18,
      7.994286,
      37,
      7.069160,
      31,
      18.498048,
      10,
      9.171170,
      20.347440,
      7.135068,
      1,
      0,
      25.033398,
      4.706395,
      146.626707,
      20,
      0.097049,
      28.607843,
      62.388983,
      75.344853,
      71.747401,
      81,
      116,
      ' 6-12-1990',
      41,
      33,
      30,
      21,
      84.545750,
      151.807611,
      ' 0-26-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      47,
      6,
      NULL,
      6,
      8.676240,
      NULL,
      NULL,
      1.185773,
      1.211693,
      149,
      0,
      1,
      176.285720,
      1,
      1,
      80.849013,
      NULL,
      NULL,
      NULL,
      ' 3-12-1984',
      0.539915,
      98,
      114,
      5.830108,
      71.962880,
      31.123039,
      118.928185,
      81.258495,
      57.138901,
      62.099369,
      71.817596,
      92,
      ' 1-11-1991',
      NULL,
      5.662067,
      1.976617,
      NULL,
      NULL,
      143,
      10.972315,
      '10- 9-1989',
      32,
      26,
      ' 0-12-1981',
      12.042352,
      16.306417,
      10.541156,
      24,
      9.869233,
      12,
      1.811673,
      6.641654,
      1.400042,
      16.766909,
      1.147449,
      NULL,
      29,
      4.195227,
      0,
      1.852807,
      NULL,
      1.336247,
      '10-29-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      79.152778,
      0,
      '10- 2-2002',
      NULL,
      NULL,
      NULL,
      34,
      NULL,
      19.737968,
      NULL,
      15,
      3.658094,
      ' 1-11-1980',
      NULL,
      17,
      ' 5- 1-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      6.339642,
      '11- 7-1998',
      25,
      28,
      39,
      '11-17-1987',
      1.634519,
      NULL,
      ' 1- 9-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


