set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7128585';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1231',
      '23340201',
      '12142221',
      '31044234',
      NULL,
      '21303330',
      '40404243',
      '01412220',
      NULL,
      NULL,
      '44124103',
      '21304023',
      '00230344',
      '22143044',
      '44002113',
      NULL,
      '21122324',
      '24012132',
      '03401030',
      '34241440',
      NULL,
      '00231032',
      '01040343',
      '24232241',
      NULL,
      '23144200',
      '42420420',
      '20000314',
      '24440132',
      '42430201',
      '43101301',
      '41232202',
      '32204200',
      '02212024',
      '21410023',
      '30130134',
      '12411303',
      NULL,
      '41043302',
      '22104000',
      '14344302',
      '42411233',
      '33221133',
      '22233024',
      '00030212',
      '111',
      '22',
      23,
      10,
      NULL,
      2,
      1,
      2,
      NULL,
      '131222',
      1,
      ' 8-10-1986',
      ' 6-23-2001',
      70.701313,
      NULL,
      5,
      6,
      30.833798,
      NULL,
      66.479796,
      8,
      13,
      18,
      24.189666,
      NULL,
      NULL,
      10.700266,
      22,
      6,
      15,
      NULL,
      NULL,
      19,
      0,
      16.426555,
      95.482235,
      24,
      1,
      20,
      132,
      NULL,
      NULL,
      186.354943,
      182.677036,
      ' 6- 1-1989',
      39,
      33.665306,
      0,
      1,
      NULL,
      164,
      '10- 1-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      52,
      9,
      NULL,
      13.167794,
      8,
      3,
      ' 1-17-1975',
      0.229176,
      2,
      171,
      0,
      3,
      22,
      3,
      0.734077,
      85,
      NULL,
      NULL,
      NULL,
      NULL,
      61,
      NULL,
      18.373933,
      43.485135,
      99,
      NULL,
      NULL,
      33,
      47.403472,
      NULL,
      67,
      90.341506,
      ' 5-19-1992',
      NULL,
      NULL,
      11.353652,
      72.766682,
      6,
      116,
      8,
      ' 5-17-1977',
      NULL,
      15,
      NULL,
      5.844887,
      8.405685,
      NULL,
      7,
      4,
      6,
      1,
      22.965768,
      0,
      13,
      0,
      1.230802,
      18,
      20.839739,
      3.271359,
      0,
      0,
      0.350240,
      ' 3- 1-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      218,
      NULL,
      ' 0-20-1993',
      NULL,
      NULL,
      NULL,
      23,
      '11- 7-1985',
      45.117099,
      ' 4-27-1982',
      9.394525,
      10,
      '11-22-1998',
      NULL,
      96.589087,
      ' 7-18-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      22.979897,
      ' 7-25-1985',
      39,
      22,
      23.956133,
      ' 8- 8-2001',
      0,
      8.432684,
      '10-17-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


