set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6603086';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '10344314',
      '21414234',
      '41222004',
      NULL,
      NULL,
      '31202321',
      NULL,
      '32031144',
      NULL,
      '32004023',
      '32040331',
      '02203110',
      '40331434',
      '21324024',
      '30024303',
      '30140121',
      '00402004',
      '41000402',
      '34121023',
      '11221433',
      NULL,
      '13012330',
      NULL,
      '42231412',
      NULL,
      '20141201',
      NULL,
      '31204121',
      '23342012',
      '10403421',
      '24122411',
      '34114333',
      '02303232',
      '11013244',
      '02412104',
      '24320144',
      '14414243',
      '14134024',
      NULL,
      '44100002',
      '13311433',
      '44213233',
      '20122143',
      NULL,
      '321',
      '31',
      NULL,
      NULL,
      '1031201',
      1,
      0,
      2,
      NULL,
      '113130',
      5.567958,
      ' 9- 7-1984',
      NULL,
      73,
      NULL,
      46.107109,
      NULL,
      40,
      18.684307,
      102,
      NULL,
      11.337881,
      NULL,
      23.669773,
      NULL,
      23.872649,
      19,
      NULL,
      3,
      21,
      5.296842,
      13.184934,
      3.673398,
      4,
      11.686513,
      57.244069,
      12,
      NULL,
      45.317402,
      153,
      30,
      65.640805,
      13,
      80,
      ' 9-20-1989',
      33.676132,
      34.810663,
      25.854558,
      0.846243,
      187,
      173.653236,
      '11-26-2002',
      NULL,
      1.529007,
      1,
      1.844255,
      1.423733,
      0,
      0.952175,
      NULL,
      NULL,
      1.107237,
      0.315754,
      0.450401,
      0.557146,
      0.248075,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-25-1987',
      12,
      5,
      6.805967,
      NULL,
      1,
      8,
      ' 8- 8-1991',
      NULL,
      1,
      138.320578,
      1,
      1.429862,
      121.639580,
      2.238168,
      5.829714,
      28.291185,
      1,
      0.643663,
      62,
      ' 1-14-1985',
      103,
      59,
      106,
      32.677873,
      8.955015,
      85,
      NULL,
      59,
      38,
      37.067324,
      18,
      91,
      '11-13-1989',
      24,
      2.298263,
      19,
      88,
      11,
      141.732050,
      6,
      ' 3-24-1986',
      NULL,
      NULL,
      '10- 0-1985',
      6.050951,
      NULL,
      17,
      26,
      2,
      11.135672,
      1.322755,
      2.561313,
      1,
      NULL,
      NULL,
      3.004334,
      5.121593,
      21,
      NULL,
      1.790639,
      0.616533,
      1.114820,
      ' 3-25-1989',
      3,
      NULL,
      4,
      ' 1- 0-1997',
      NULL,
      4,
      NULL,
      4.240743,
      NULL,
      ' 0-14-1999',
      5,
      ' 7-13-1975',
      36.285482,
      ' 1-25-1991',
      2,
      NULL,
      ' 7-28-2003',
      NULL,
      NULL,
      NULL,
      1,
      1.828501,
      NULL,
      NULL,
      1.439868,
      '10- 6-1991',
      3,
      0,
      NULL,
      NULL,
      16.385177,
      NULL,
      NULL,
      '11- 3-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.426217);
commit;
end;
/


