set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6803294';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2402',
      '30424004',
      '20032340',
      '20224441',
      '30340041',
      '02343023',
      '42122041',
      '11434204',
      '32403323',
      '14100140',
      '22433113',
      '13240223',
      NULL,
      '42202233',
      NULL,
      '03320233',
      NULL,
      '04102110',
      '31100210',
      '04331314',
      NULL,
      '44400212',
      NULL,
      '43031441',
      '01121040',
      '20231244',
      NULL,
      '40212432',
      NULL,
      '43311210',
      '20422234',
      '34101422',
      '10334401',
      '10224321',
      '20342212',
      '20310121',
      '11442334',
      NULL,
      '20133410',
      '32200423',
      '41410343',
      '42121203',
      '04103234',
      NULL,
      '22140304',
      '230',
      '13',
      NULL,
      NULL,
      '0210134',
      NULL,
      NULL,
      3,
      NULL,
      '344401',
      2,
      ' 4-26-1994',
      '11- 3-1982',
      1.405782,
      NULL,
      34.625899,
      12,
      29,
      NULL,
      33.687367,
      10.765428,
      25.523855,
      NULL,
      10,
      NULL,
      4.955672,
      3,
      30.859541,
      13,
      5.989722,
      20.998952,
      70,
      3.525936,
      43,
      NULL,
      81.978380,
      13.046221,
      0.486502,
      95.820740,
      43.026750,
      104,
      95.673492,
      221.312034,
      204,
      NULL,
      33.063340,
      55.492148,
      9,
      41,
      84.124214,
      66.007579,
      '11-26-1981',
      0,
      NULL,
      0.037813,
      0.233646,
      0,
      3,
      NULL,
      NULL,
      0,
      0,
      0,
      1.367027,
      0,
      NULL,
      2.393438,
      1,
      0.677461,
      0.330114,
      1.263782,
      1.507449,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-24-1985',
      44,
      13.206579,
      3.239817,
      14,
      0,
      11.285886,
      NULL,
      1,
      1,
      90.587065,
      0,
      0.463841,
      77,
      3.026531,
      NULL,
      NULL,
      0.716215,
      0.267793,
      125.336732,
      ' 6-10-1992',
      85.774697,
      NULL,
      104.272138,
      53.471986,
      66,
      21.117539,
      5,
      9.512354,
      47,
      104.133158,
      72.814253,
      85,
      ' 6- 5-1980',
      17,
      22,
      25,
      7,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      ' 2-14-2001',
      8,
      NULL,
      NULL,
      14,
      14.940114,
      8,
      1,
      17.208211,
      NULL,
      46.736947,
      0.469586,
      1.094326,
      6.057676,
      29,
      2.620216,
      3.451821,
      1.662694,
      1,
      ' 6-14-1997',
      1.479774,
      0,
      2.941331,
      ' 1- 8-1984',
      270,
      NULL,
      ' 6- 4-1993',
      49.490927,
      0.293208,
      ' 5- 9-2003',
      50.703379,
      ' 3- 9-1978',
      3.736997,
      ' 7-10-1997',
      0.553550,
      NULL,
      ' 0-23-1996',
      155,
      NULL,
      ' 1- 9-1980',
      1,
      10,
      ' 1-23-1977',
      5.612439,
      11.150173,
      NULL,
      1,
      1,
      23,
      ' 3-12-1981',
      69,
      NULL,
      15.840400,
      '11-27-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.375358);
commit;
end;
/


