set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9500455';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2222',
      '41114241',
      '44133322',
      '30420300',
      NULL,
      '23120100',
      '00340333',
      '34411140',
      '24440240',
      '20213013',
      '14114230',
      '03312022',
      NULL,
      NULL,
      NULL,
      '24121243',
      '20141302',
      '33233240',
      '04433420',
      '14020210',
      NULL,
      '32120432',
      '14244224',
      '10314343',
      '31322420',
      '20020024',
      '40131242',
      '14110414',
      '32340333',
      '40014331',
      NULL,
      '13240341',
      '33231413',
      '30012121',
      NULL,
      '10421014',
      '23431124',
      '13323430',
      NULL,
      '24412003',
      '44220311',
      NULL,
      NULL,
      '10233141',
      '23321012',
      NULL,
      '40',
      NULL,
      NULL,
      '2442314',
      0.071130,
      NULL,
      2,
      NULL,
      NULL,
      0.310422,
      NULL,
      ' 1-28-1991',
      15,
      NULL,
      NULL,
      22,
      11,
      15,
      102.993175,
      15.296746,
      NULL,
      14.035207,
      7.896340,
      16,
      22,
      3,
      1.556059,
      1.274972,
      8.701328,
      3.044574,
      31.098802,
      1,
      4.008987,
      NULL,
      114,
      6,
      1,
      155.361638,
      208.169628,
      NULL,
      169.967185,
      140,
      NULL,
      ' 8-14-1989',
      NULL,
      NULL,
      20.896098,
      16,
      117.219729,
      87,
      ' 2-11-1992',
      NULL,
      2,
      0.893170,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.817363,
      1,
      0,
      1.156201,
      1.205683,
      NULL,
      1.121233,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.615184,
      3,
      9.400670,
      NULL,
      ' 0- 6-1980',
      0,
      NULL,
      18,
      0.996327,
      0.814250,
      140.985862,
      0.442674,
      3.508556,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 7-1984',
      101,
      56,
      28.890935,
      57,
      71,
      1.375132,
      54.281710,
      36,
      8.837076,
      33.791101,
      46.551856,
      87,
      ' 1-15-1992',
      18.920620,
      3,
      19.998928,
      11.324276,
      108,
      144.435204,
      15,
      NULL,
      20,
      20.209162,
      '11- 5-2002',
      1.458093,
      18,
      15.246526,
      16,
      14.472601,
      8.967459,
      1,
      19.580674,
      NULL,
      81,
      NULL,
      3.133857,
      2,
      4,
      2.773319,
      2,
      7.942154,
      1,
      ' 1-28-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      23.111053,
      0.877266,
      ' 1- 7-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-18-1982',
      9.350874,
      NULL,
      NULL,
      6.106710,
      ' 2-16-1989',
      147,
      28.101979,
      ' 7-16-1979',
      NULL,
      2,
      ' 3-11-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      21,
      '11- 8-1977',
      30,
      3.072046,
      1,
      ' 3-26-1979',
      1,
      8,
      '10-13-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


