set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9944050';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '1',
      '1',
      '1',
      NULL,
      '2',
      '3',
      '3',
      '4',
      '1',
      '3',
      '3',
      '3',
      '2',
      '2',
      '4',
      NULL,
      '4',
      NULL,
      NULL,
      '4',
      '4',
      '3',
      '3',
      '',
      '2',
      '',
      NULL,
      '3',
      NULL,
      NULL,
      '1',
      '',
      '',
      NULL,
      '4',
      '0',
      '3',
      '3',
      '3',
      '0',
      '2',
      '3',
      '3',
      '4',
      NULL,
      '22221440',
      62,
      12,
      NULL,
      NULL,
      1.335572,
      1,
      0,
      '322442',
      5.347201,
      ' 7- 1-1984',
      ' 7-25-1980',
      90.462114,
      112,
      12.826059,
      4,
      NULL,
      2,
      64,
      NULL,
      9,
      0,
      NULL,
      14,
      14,
      9,
      NULL,
      NULL,
      NULL,
      1.437444,
      19.323209,
      NULL,
      40.923933,
      3,
      46,
      NULL,
      0.180519,
      29,
      153,
      NULL,
      13.413209,
      37.344057,
      NULL,
      ' 0-14-2001',
      NULL,
      8.358266,
      13,
      20,
      104,
      NULL,
      ' 3-11-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      87.670768,
      27,
      22,
      13.911358,
      7,
      NULL,
      NULL,
      0.636093,
      NULL,
      123.813831,
      0,
      1.625384,
      NULL,
      0.642158,
      NULL,
      40,
      NULL,
      NULL,
      NULL,
      ' 8- 1-1976',
      67,
      33,
      13,
      NULL,
      NULL,
      68.586718,
      42,
      NULL,
      63,
      NULL,
      32.477338,
      64.477447,
      ' 3-14-1977',
      0,
      15.095860,
      NULL,
      NULL,
      NULL,
      9.603006,
      NULL,
      ' 7-19-1983',
      NULL,
      20,
      '10-16-1979',
      7.318761,
      NULL,
      4.690485,
      NULL,
      NULL,
      5.422698,
      0.379435,
      3,
      0,
      39,
      1.973031,
      NULL,
      1,
      1,
      1,
      0.484471,
      0,
      1,
      ' 9- 0-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      55.288413,
      9.405729,
      ' 7-20-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      '11-17-2000',
      14.842774,
      ' 6-21-1989',
      7,
      4.198792,
      '10-28-1996',
      46,
      67.341535,
      ' 8-24-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      '11- 0-1984',
      NULL,
      24,
      40.229505,
      '11-21-1978',
      2.913960,
      291.303889,
      ' 1- 5-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


