set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9223205';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '14311402',
      '31024403',
      '00311411',
      '30303241',
      '22133233',
      '43242021',
      NULL,
      '41130303',
      NULL,
      '32101310',
      '10122222',
      NULL,
      '11231242',
      '43331442',
      NULL,
      '22244314',
      '02313241',
      NULL,
      NULL,
      '30124231',
      '30402300',
      '10114131',
      '31114231',
      NULL,
      '20420234',
      '44231410',
      '00103342',
      '13240201',
      '03410342',
      '22443203',
      '20112022',
      NULL,
      '40314424',
      NULL,
      '02010343',
      '20014321',
      '24343211',
      '23041333',
      NULL,
      '34311413',
      '20321132',
      '14241404',
      '41410432',
      '40432311',
      '143',
      '23',
      45,
      NULL,
      '3203413',
      1,
      NULL,
      2,
      NULL,
      '312300',
      1.574144,
      NULL,
      ' 0-16-1985',
      35,
      11,
      45,
      14,
      46.098952,
      NULL,
      17.469296,
      NULL,
      NULL,
      22,
      27.041778,
      NULL,
      42,
      0.563235,
      32.415261,
      18.506413,
      1.437898,
      2.513531,
      56,
      7,
      40,
      NULL,
      NULL,
      NULL,
      NULL,
      122,
      122.220733,
      NULL,
      93,
      153.184772,
      98,
      ' 8-18-1979',
      29,
      59,
      38,
      20,
      48,
      142,
      NULL,
      3,
      0.099902,
      3,
      3.518682,
      2,
      0.859746,
      NULL,
      0.982555,
      0,
      NULL,
      2,
      0.916055,
      1,
      1,
      NULL,
      0,
      3.461443,
      1,
      0.636806,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-14-1988',
      3,
      13.439700,
      NULL,
      7,
      9.145675,
      NULL,
      ' 4-22-1988',
      0.399598,
      NULL,
      149,
      NULL,
      0.086165,
      157,
      0,
      0.792665,
      19,
      NULL,
      NULL,
      NULL,
      ' 8-11-1976',
      NULL,
      NULL,
      35,
      113,
      53.699427,
      67.050206,
      53.181938,
      NULL,
      NULL,
      39.954728,
      NULL,
      88.360221,
      NULL,
      NULL,
      7.281673,
      3,
      11,
      NULL,
      NULL,
      3.833692,
      ' 8-27-1988',
      10,
      1,
      NULL,
      7.489275,
      20,
      23.015073,
      18.710189,
      31.028579,
      2.904035,
      2.483345,
      0.768858,
      0,
      120.574599,
      1.867873,
      0,
      17.282139,
      25.885752,
      1,
      NULL,
      1.861129,
      0,
      '11- 8-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      172.527556,
      0.435939,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-13-1987',
      45.181114,
      ' 7-10-1985',
      13.966787,
      3.425674,
      NULL,
      108.855588,
      NULL,
      ' 7- 8-1990',
      0.462844,
      0.242823,
      ' 3- 8-1983',
      NULL,
      NULL,
      NULL,
      0,
      1,
      10,
      ' 8-27-1993',
      27,
      19,
      16,
      ' 6- 7-1976',
      1.041346,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


