set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8529806';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '33203231',
      '22031244',
      '00343401',
      NULL,
      '21012210',
      '42120244',
      '34143333',
      '11200001',
      '24110202',
      '01342433',
      '24411002',
      '22440144',
      '13320400',
      '21242041',
      '34043113',
      '34131430',
      '41303331',
      '11134331',
      NULL,
      NULL,
      '31330342',
      '01122123',
      '34440234',
      '12324333',
      NULL,
      NULL,
      '23104311',
      NULL,
      NULL,
      '23114433',
      '33401224',
      '20424341',
      '02344014',
      NULL,
      '24242322',
      NULL,
      '20414214',
      '14332013',
      '02134123',
      '22341303',
      '04421010',
      NULL,
      '03240040',
      '01400422',
      '',
      '',
      NULL,
      NULL,
      '0413022',
      0.728131,
      NULL,
      NULL,
      NULL,
      '231103',
      NULL,
      ' 8- 5-1994',
      NULL,
      67.510231,
      NULL,
      25.544846,
      9,
      NULL,
      21.954901,
      62.508145,
      2,
      25.378118,
      3.709588,
      2,
      NULL,
      28.693899,
      1.175684,
      8,
      NULL,
      13,
      8,
      1,
      16.294072,
      62.079943,
      4.734521,
      16,
      13,
      NULL,
      NULL,
      184.883577,
      48,
      1.861834,
      163.836531,
      NULL,
      '11-10-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      6,
      1.335673,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      1,
      1.231073,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-12-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      54.850148,
      100.666231,
      46,
      59,
      66.219587,
      27,
      45.399216,
      79,
      NULL,
      9,
      49.559501,
      42.228014,
      ' 0- 8-1991',
      11.195716,
      6,
      NULL,
      62.171555,
      56.724086,
      29.557253,
      2.662310,
      '10- 2-1999',
      14,
      16.125773,
      NULL,
      13,
      11.116596,
      NULL,
      NULL,
      16,
      1,
      NULL,
      6,
      NULL,
      8.872439,
      NULL,
      1.591878,
      3.017555,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-14-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      26.812264,
      9,
      ' 1-24-2003',
      1,
      56,
      ' 4-27-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      105,
      NULL,
      NULL,
      NULL,
      NULL,
      60.506177,
      48.555305,
      4,
      18,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      13,
      1.104867,
      NULL,
      1.238819,
      1,
      0.901287,
      5.605669,
      NULL,
      ' 1-18-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-15-1986',
      NULL);
commit;
end;
/


