set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8400187';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      NULL,
      '4',
      '1',
      '0',
      '0',
      '3',
      '1',
      '0',
      NULL,
      NULL,
      '3',
      '2',
      '2',
      '1',
      '4',
      '4',
      '3',
      '0',
      '2',
      NULL,
      '3',
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      '3',
      '3',
      NULL,
      '',
      '',
      '0',
      NULL,
      '4',
      '3',
      '1',
      '2',
      '2',
      '0',
      '3',
      '4',
      '4',
      '411',
      '13404300',
      4,
      NULL,
      '4113032',
      1,
      0.920695,
      3,
      NULL,
      '240130',
      NULL,
      NULL,
      ' 5- 9-1990',
      4,
      NULL,
      23,
      NULL,
      NULL,
      NULL,
      80.642597,
      11,
      NULL,
      8.213071,
      NULL,
      9.343017,
      45.410247,
      12,
      26,
      17,
      23.440505,
      1.911974,
      52.584396,
      18.107493,
      12,
      17,
      NULL,
      4.570592,
      0,
      3.933136,
      7,
      18.223227,
      82.187788,
      224.003088,
      NULL,
      ' 9-16-1976',
      24.577514,
      47,
      27.396230,
      21.179828,
      175,
      NULL,
      ' 7-26-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      51.899932,
      22.403133,
      NULL,
      NULL,
      10.156946,
      6.673072,
      ' 3-14-1986',
      1.328387,
      1,
      172,
      1.563050,
      0.762324,
      159,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      58.580294,
      107.373843,
      81,
      68,
      75,
      59.352294,
      23.220465,
      73.678304,
      NULL,
      43.198258,
      14,
      23,
      '11-14-1994',
      20.332871,
      13,
      17,
      12.893638,
      49,
      NULL,
      0.221543,
      ' 9- 4-1995',
      0,
      7,
      ' 6-19-1983',
      8,
      8,
      9.852855,
      20,
      15,
      15.524087,
      NULL,
      7.676312,
      0.064539,
      27.138297,
      NULL,
      0.105152,
      1,
      6.348368,
      NULL,
      1.382264,
      1.713451,
      0.000138,
      '11- 7-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      146,
      15,
      '11-16-1985',
      NULL,
      NULL,
      NULL,
      1.489769,
      '11-12-1988',
      6.196954,
      '11- 5-1976',
      9,
      NULL,
      ' 4-17-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      ' 9-17-1978',
      47,
      5.245653,
      0.047797,
      ' 5-15-1977',
      0.564490,
      121.323057,
      ' 3-10-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


