set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7837872';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '4',
      '2',
      '1',
      '4',
      NULL,
      '0',
      NULL,
      NULL,
      '0',
      NULL,
      '3',
      '3',
      '1',
      '0',
      '3',
      NULL,
      '0',
      '1',
      NULL,
      '4',
      '3',
      NULL,
      '4',
      '',
      '4',
      NULL,
      '3',
      '4',
      '3',
      '2',
      '1',
      '',
      '',
      '3',
      '1',
      '1',
      NULL,
      NULL,
      '1',
      '0',
      '2',
      '0',
      '4',
      '4',
      '131',
      NULL,
      14,
      47,
      '0322120',
      3,
      NULL,
      1,
      NULL,
      '230101',
      5,
      NULL,
      ' 0-19-1974',
      125.088003,
      54,
      24,
      NULL,
      NULL,
      27,
      88.938604,
      NULL,
      NULL,
      13.371063,
      NULL,
      NULL,
      4,
      31.566765,
      29,
      19.727539,
      18,
      10.697498,
      30.382241,
      1,
      12.779541,
      0,
      48,
      6.217517,
      0,
      47,
      192.684950,
      78,
      109,
      29.322508,
      52.891569,
      NULL,
      0,
      NULL,
      NULL,
      32.936117,
      165,
      68,
      ' 4- 7-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      88.892682,
      18.265839,
      13.205648,
      0,
      10.383004,
      NULL,
      '11- 7-1979',
      0,
      3,
      14,
      1,
      NULL,
      NULL,
      1,
      1.827565,
      87,
      NULL,
      NULL,
      NULL,
      ' 2-11-2003',
      113.460618,
      110.789736,
      78.066577,
      13.896982,
      31.084797,
      26.432699,
      1.301342,
      NULL,
      15.159045,
      NULL,
      23,
      43.314851,
      ' 1- 7-1976',
      31.695634,
      35,
      15,
      103.662483,
      NULL,
      16,
      14.673810,
      '11-20-1998',
      15,
      NULL,
      ' 2-13-1994',
      4.749680,
      6.555520,
      13.422760,
      18.867387,
      21.909685,
      4,
      NULL,
      11.107043,
      0.484130,
      81,
      1.600725,
      1.454904,
      17,
      NULL,
      2,
      2.081253,
      1.157881,
      1.747912,
      ' 7- 9-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 3-27-1994',
      NULL,
      NULL,
      NULL,
      49.452435,
      ' 5-27-1986',
      25,
      NULL,
      NULL,
      1,
      ' 0-17-1974',
      90,
      87,
      ' 8-18-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      14.224591,
      ' 6-21-1993',
      44.091059,
      11,
      32.881206,
      ' 6- 3-1999',
      3,
      46,
      ' 2-27-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


