set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9030982';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '43430000',
      '20401410',
      '12032112',
      '13323331',
      '32124011',
      NULL,
      NULL,
      '42432344',
      '02424144',
      '02404001',
      NULL,
      '11123140',
      '43113342',
      '33041143',
      '40333233',
      '20340310',
      '42413444',
      '40000202',
      NULL,
      '41333023',
      '21100020',
      NULL,
      '43312041',
      '01313324',
      NULL,
      NULL,
      '12300140',
      '04221211',
      '31322300',
      '13314441',
      '03412304',
      '01233024',
      NULL,
      '11210441',
      '13004224',
      '41023442',
      '32401211',
      '23422230',
      '20024131',
      '44332344',
      '21143021',
      NULL,
      '00031321',
      NULL,
      '012',
      '32',
      NULL,
      NULL,
      '2240303',
      0,
      0,
      3,
      NULL,
      NULL,
      0.073317,
      ' 9-17-2003',
      NULL,
      59.442546,
      NULL,
      15.514078,
      17.617961,
      12.890850,
      11.838860,
      NULL,
      13.502428,
      15.607089,
      6.759684,
      19,
      NULL,
      9,
      11.440885,
      28.194742,
      10.010559,
      NULL,
      NULL,
      73,
      13.043280,
      67,
      24.037679,
      72.764689,
      5.711661,
      NULL,
      113.275006,
      94,
      141,
      249,
      29.370151,
      NULL,
      ' 6-12-1980',
      41,
      28,
      NULL,
      28,
      NULL,
      178.504178,
      ' 9-22-1994',
      0.113957,
      0,
      2,
      NULL,
      1.908017,
      3.193542,
      2,
      NULL,
      1,
      1,
      1,
      0.322042,
      NULL,
      NULL,
      3.958188,
      1.242755,
      1,
      1.117208,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-16-1981',
      93.331189,
      NULL,
      13,
      7.273064,
      0.747693,
      8.393381,
      ' 4-23-1990',
      0,
      NULL,
      17,
      0.999721,
      5,
      129.497915,
      NULL,
      3,
      53,
      NULL,
      NULL,
      NULL,
      ' 1- 3-1982',
      117.412255,
      127,
      34.953070,
      10,
      78.491276,
      NULL,
      113,
      21,
      5.345425,
      72.582919,
      53.216867,
      37,
      ' 5-15-1995',
      7,
      5.914783,
      NULL,
      50.378556,
      23.009547,
      8,
      NULL,
      ' 1-16-1991',
      NULL,
      7.325713,
      ' 4-11-1997',
      3.414855,
      27.805794,
      NULL,
      21.600880,
      NULL,
      13,
      1.702588,
      NULL,
      0.587490,
      78.270538,
      1,
      1,
      24,
      6,
      0,
      0,
      0,
      1.018125,
      ' 9-11-2000',
      7,
      NULL,
      0,
      ' 6- 6-1992',
      171.260826,
      2.154537,
      ' 4-22-2000',
      NULL,
      14.726289,
      NULL,
      29.588040,
      ' 8-26-1977',
      17.462414,
      ' 5-11-1978',
      17,
      15,
      ' 6- 5-1996',
      91.477515,
      0.891109,
      ' 1-12-1999',
      0.441757,
      2,
      '10-14-1992',
      0.063210,
      2,
      ' 9- 8-1997',
      2,
      1,
      NULL,
      ' 0- 8-1980',
      15,
      30,
      NULL,
      ' 4-15-1985',
      1,
      0.577100,
      '10-26-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0);
commit;
end;
/


