set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9025733';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4123',
      '14141314',
      '23314130',
      '24323411',
      '34111212',
      '40404410',
      NULL,
      '32441231',
      '22034130',
      '43241110',
      '13434012',
      NULL,
      '20111241',
      '30302124',
      NULL,
      '24232211',
      '44222031',
      '24032134',
      '34342411',
      '44341241',
      '04213123',
      '03020340',
      NULL,
      '12024230',
      '33141213',
      '02241022',
      NULL,
      '21104410',
      NULL,
      '23223132',
      '20010132',
      '10040321',
      NULL,
      '20032123',
      '03102442',
      NULL,
      NULL,
      '40143000',
      '21213114',
      NULL,
      '33100013',
      '32202343',
      NULL,
      '32313423',
      NULL,
      '401',
      '22',
      NULL,
      NULL,
      '3101101',
      2.525062,
      1.661303,
      0,
      NULL,
      '434114',
      3,
      ' 7-22-2003',
      ' 4-17-1978',
      36.085098,
      NULL,
      6.356031,
      13.791579,
      NULL,
      8.082277,
      NULL,
      14.703175,
      23.426007,
      13.903093,
      9,
      3,
      39.138196,
      13.921351,
      32,
      11.942855,
      3.293155,
      6,
      21,
      1.036047,
      NULL,
      22,
      NULL,
      32.371133,
      0.758295,
      49.384533,
      36,
      118.446042,
      225.829683,
      247,
      26.143249,
      '11- 7-1985',
      18,
      13.518153,
      21.725589,
      26,
      195.274366,
      NULL,
      ' 6-27-1979',
      0,
      0,
      NULL,
      1,
      0.967318,
      0.119819,
      5.052047,
      NULL,
      0,
      0.238805,
      0.528247,
      NULL,
      1.834329,
      0,
      NULL,
      0,
      1.258167,
      0,
      1.116373,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-11-1990',
      18,
      9.736638,
      NULL,
      1,
      6.686626,
      NULL,
      ' 3-13-1974',
      1.393014,
      1.387700,
      114,
      0.121309,
      0.091049,
      NULL,
      0,
      NULL,
      91.052854,
      0.759395,
      NULL,
      NULL,
      ' 3-28-1978',
      23,
      92,
      23,
      11,
      81,
      28.613599,
      NULL,
      NULL,
      76.440553,
      70,
      9.281979,
      89,
      '10-28-2001',
      19,
      14,
      12,
      55,
      62.441616,
      21.020100,
      8.220857,
      NULL,
      7,
      NULL,
      ' 1-16-2002',
      11.216593,
      1.932048,
      24,
      9,
      NULL,
      8,
      0,
      0,
      1.012717,
      125.056791,
      0.999623,
      1.262572,
      16.672205,
      NULL,
      1,
      2,
      0,
      NULL,
      ' 6- 6-1992',
      3.082009,
      6.228857,
      NULL,
      NULL,
      64,
      1.334237,
      NULL,
      28,
      1,
      ' 6-19-1983',
      15.655498,
      ' 0-26-1984',
      35,
      NULL,
      3,
      18.115725,
      ' 6-26-1988',
      38.190505,
      37.986022,
      NULL,
      1.615427,
      5.213565,
      ' 8-16-1994',
      NULL,
      5,
      ' 2-25-1977',
      3,
      1,
      NULL,
      NULL,
      5,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14.831594);
commit;
end;
/


