set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8723478';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3344',
      '02402122',
      NULL,
      NULL,
      NULL,
      '33014123',
      '12104343',
      NULL,
      '20103244',
      NULL,
      '03331320',
      '24241303',
      '31441340',
      '40142144',
      '42012003',
      '03032003',
      '04022000',
      '13222141',
      NULL,
      '20113404',
      '03210110',
      '20231421',
      '31401030',
      NULL,
      '13021222',
      '41443421',
      NULL,
      '42201344',
      NULL,
      '13020112',
      '44411201',
      '00422443',
      NULL,
      '22332011',
      NULL,
      '00033012',
      NULL,
      '20013340',
      '21143321',
      '33134221',
      NULL,
      '44423011',
      NULL,
      NULL,
      '00134004',
      NULL,
      '',
      NULL,
      NULL,
      '1043223',
      1,
      0.415266,
      1,
      NULL,
      '021001',
      3.108106,
      ' 1-25-1992',
      NULL,
      2,
      NULL,
      40,
      NULL,
      16,
      16,
      69,
      4.265692,
      22,
      9.380832,
      NULL,
      3.334011,
      39,
      18.886212,
      26,
      6.618025,
      0.644801,
      3,
      NULL,
      0,
      NULL,
      10.737471,
      NULL,
      3.536210,
      NULL,
      116.200841,
      158,
      39,
      NULL,
      1,
      92,
      ' 6- 9-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.881025,
      0.723593,
      0.417126,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-17-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-27-1995',
      19,
      57.163857,
      NULL,
      109,
      62.409388,
      NULL,
      30.114092,
      124,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 7-1987',
      7.738166,
      6,
      3.719369,
      0.101142,
      70,
      7,
      11.210123,
      NULL,
      NULL,
      5,
      ' 6-10-1983',
      10.410220,
      NULL,
      27.677800,
      16.170288,
      17.090167,
      11.814766,
      NULL,
      NULL,
      NULL,
      0.853349,
      NULL,
      4.907690,
      20,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-11-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      45,
      7.236630,
      10,
      NULL,
      NULL,
      9,
      ' 5-16-1974',
      14,
      NULL,
      NULL,
      40,
      ' 2- 3-1974',
      66.127845,
      0,
      191.185722,
      ' 5-17-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      1.765932,
      0,
      NULL,
      18,
      46,
      24,
      7,
      8,
      0,
      NULL,
      50.884255,
      1,
      0.578388,
      80,
      1,
      0.038689,
      55,
      0.538036,
      6.744357,
      58,
      1,
      0.132634,
      NULL,
      105.288553,
      27.200700,
      108,
      NULL,
      88,
      0,
      NULL,
      NULL,
      0,
      6,
      0.905924,
      NULL,
      36.501657,
      1.264286,
      1,
      NULL,
      118.375795,
      NULL,
      0.016842,
      NULL,
      1.157948,
      1.506233,
      1.095424,
      19,
      NULL,
      38,
      1.034240,
      60,
      0,
      NULL,
      79.772190,
      5,
      18.780112,
      18.712812,
      NULL,
      55.856868,
      11,
      54.563020,
      17.692257,
      2.224044,
      1.119585,
      NULL,
      0.942123,
      1,
      0.346914,
      1,
      14,
      NULL,
      ' 5-26-1997',
      ' 0- 3-1995',
      NULL,
      ' 4-18-1980',
      ' 6-16-1998',
      '11- 5-1986',
      NULL);
commit;
end;
/


