set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8723478';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2323',
      '04410142',
      '11341113',
      '33341003',
      '01444201',
      '31112222',
      NULL,
      '01011201',
      '34112411',
      NULL,
      '14013004',
      '33243204',
      '31013312',
      '34243213',
      NULL,
      NULL,
      '30242124',
      '34314030',
      NULL,
      '34141204',
      '10434411',
      '42232011',
      NULL,
      '41244032',
      NULL,
      '03130404',
      '20104200',
      '43214442',
      NULL,
      '11200421',
      '33333104',
      '30111423',
      '32403111',
      NULL,
      '31424324',
      '13141414',
      NULL,
      '33034032',
      '20302414',
      '32340132',
      '40104311',
      '43230444',
      '03420411',
      NULL,
      '00341111',
      '',
      '',
      NULL,
      NULL,
      '3444244',
      NULL,
      42,
      0,
      NULL,
      '302023',
      NULL,
      NULL,
      ' 9-22-1977',
      24.935050,
      NULL,
      40.998581,
      13,
      15,
      12.909335,
      68.094188,
      10.937198,
      NULL,
      15.735396,
      3,
      NULL,
      9,
      19,
      26.807138,
      17.393859,
      NULL,
      20.302554,
      84,
      10.733533,
      25,
      18.100545,
      53.281663,
      18,
      NULL,
      NULL,
      194,
      0,
      NULL,
      40,
      214.552753,
      ' 4-28-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.826506,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.730300,
      0.775843,
      4.749102,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-21-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-17-1983',
      91,
      NULL,
      NULL,
      107.126108,
      68,
      112.701640,
      2.015056,
      94,
      30.061897,
      38.725383,
      98,
      23,
      ' 9- 9-1986',
      4,
      3.770235,
      4.877308,
      NULL,
      6.740972,
      NULL,
      2.468976,
      ' 4-23-1987',
      14.323161,
      8,
      '11- 0-1983',
      19,
      NULL,
      18,
      25,
      31.455010,
      13,
      NULL,
      NULL,
      NULL,
      122.505076,
      1,
      NULL,
      25,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-13-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      38,
      9.292716,
      NULL,
      3,
      28,
      ' 2-22-1994',
      17.771251,
      2,
      12.264988,
      NULL,
      ' 5-27-1990',
      NULL,
      0.080369,
      99,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      180.837478,
      0.241829,
      6.796331,
      114,
      58.454039,
      NULL,
      0.017446,
      2.540965,
      6.311837,
      4.590310,
      91,
      NULL,
      0.584257,
      NULL,
      1.319825,
      1,
      NULL,
      0,
      2,
      22.919927,
      NULL,
      NULL,
      134,
      103,
      NULL,
      NULL,
      0,
      53.184473,
      0,
      1.565310,
      1.893579,
      1.390896,
      0.229018,
      NULL,
      119.844612,
      6.553255,
      NULL,
      8,
      42.323810,
      3.848510,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.765429,
      90.448440,
      1,
      0.667643,
      72,
      29,
      4,
      11,
      111.514258,
      24.776812,
      NULL,
      NULL,
      9.730707,
      1.837145,
      0,
      0.114599,
      0.663503,
      1.224808,
      2.301786,
      0.285667,
      18.713486,
      NULL,
      NULL,
      ' 6-12-1981',
      NULL,
      ' 2-18-1995',
      NULL,
      ' 4- 4-1990',
      NULL);
commit;
end;
/


