set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8723478';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '40021044',
      '21241321',
      '04244002',
      NULL,
      '43210024',
      '00032313',
      '12030402',
      '41123343',
      '11103200',
      NULL,
      NULL,
      '01241003',
      '21330112',
      '12244012',
      '14100430',
      '41402324',
      '42030231',
      '32431212',
      '11311233',
      '41200301',
      '10033232',
      '33221314',
      '43230131',
      '34241124',
      '10120312',
      '40214223',
      NULL,
      '40043330',
      '14210012',
      NULL,
      '41101221',
      NULL,
      '24430210',
      NULL,
      '20230410',
      NULL,
      '01242141',
      '11104241',
      '31132301',
      '43432440',
      NULL,
      '24244300',
      '12444023',
      NULL,
      '141',
      '12',
      NULL,
      NULL,
      '4124413',
      2.552062,
      NULL,
      2,
      NULL,
      '101211',
      NULL,
      ' 2-12-1978',
      ' 9- 7-1986',
      79,
      NULL,
      9,
      16,
      NULL,
      17.469626,
      NULL,
      6.481674,
      14,
      14.307576,
      23.583812,
      11,
      NULL,
      29.301250,
      31,
      21,
      8.483838,
      13.675681,
      NULL,
      6.022170,
      49,
      4.072766,
      84,
      23,
      3.809882,
      125.963845,
      66.661231,
      124,
      NULL,
      NULL,
      25,
      ' 7-23-1980',
      54,
      16.249692,
      38,
      10.506494,
      82.136920,
      145.866515,
      NULL,
      0.042826,
      NULL,
      1,
      2,
      0,
      3,
      NULL,
      0.480716,
      NULL,
      0,
      1.845619,
      0.133595,
      1,
      2,
      1,
      NULL,
      4,
      0.661083,
      1.513871,
      1.598488,
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 1-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.381808,
      1.208968,
      49,
      1,
      1,
      136,
      0,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-27-2000',
      NULL,
      27,
      84,
      37.954079,
      101,
      NULL,
      52.466816,
      13,
      29,
      NULL,
      81,
      93,
      ' 3-19-1986',
      NULL,
      8.548086,
      7.568127,
      NULL,
      58,
      8.356830,
      2,
      ' 2-18-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      17.241369,
      8,
      8.447664,
      14,
      NULL,
      0,
      25,
      0.519647,
      27.037067,
      2.148889,
      1.276086,
      25,
      1,
      0.001748,
      0.701303,
      1,
      0.520591,
      ' 2-28-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      247.686748,
      10.262348,
      '10-18-1992',
      NULL,
      NULL,
      NULL,
      1,
      ' 5-10-1990',
      4.553714,
      ' 1-29-1992',
      4.539133,
      5,
      ' 1- 6-1983',
      NULL,
      38.482908,
      ' 8-26-1989',
      8,
      6.131084,
      ' 7-13-1991',
      NULL,
      NULL,
      NULL,
      1,
      0,
      10.974575,
      NULL,
      6,
      16.534639,
      14.075371,
      ' 6- 0-1998',
      1,
      NULL,
      ' 2-29-1992',
      8,
      8.079007,
      23,
      0.798162,
      ' 2-13-1991',
      NULL,
      1.567977,
      133,
      ' 2-27-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


