set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8723478';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0242',
      NULL,
      '30214430',
      '02440334',
      '23114432',
      '43002331',
      '11123424',
      '12321031',
      '34101230',
      '24211444',
      '22012423',
      '22311144',
      NULL,
      '31434130',
      NULL,
      NULL,
      NULL,
      '23013011',
      '20330302',
      '10422144',
      '14243120',
      '31211320',
      NULL,
      '43030304',
      '40013040',
      '43423134',
      NULL,
      '30223304',
      '42112024',
      '11404222',
      '13321401',
      NULL,
      '31020443',
      '01102014',
      '04224422',
      '02033134',
      '24331141',
      '34302001',
      '40120321',
      '12420042',
      '00340144',
      '12402013',
      '11123340',
      '02002133',
      '00433230',
      '133',
      '13',
      26.586736,
      10,
      '4020331',
      0.389964,
      54.203824,
      1,
      NULL,
      '002320',
      1,
      ' 4-23-1999',
      ' 3- 1-1977',
      77.007208,
      13.819639,
      49,
      23.012965,
      NULL,
      NULL,
      21,
      1.830729,
      13,
      NULL,
      22,
      12,
      11.949070,
      9.486583,
      12.584208,
      20,
      15,
      18.177317,
      44,
      7.460340,
      NULL,
      21.218942,
      NULL,
      17,
      0.737224,
      NULL,
      NULL,
      53,
      NULL,
      56.417957,
      145.376491,
      '10-23-1999',
      64,
      56,
      14,
      NULL,
      128,
      95.138929,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      44,
      10.245339,
      11.935719,
      NULL,
      4,
      0.936127,
      ' 2- 2-2000',
      NULL,
      1,
      20.946676,
      1.945516,
      1,
      73.295499,
      0.693414,
      0,
      47.316859,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      45.287808,
      3,
      37,
      21.147669,
      NULL,
      36,
      6,
      NULL,
      67,
      79.808922,
      45,
      ' 1-20-1994',
      16.257851,
      0,
      NULL,
      5.401801,
      40,
      1,
      NULL,
      ' 9- 1-1975',
      29,
      22,
      NULL,
      3.829668,
      6,
      NULL,
      3,
      21.820791,
      9.678013,
      0.050981,
      21,
      1.578626,
      NULL,
      0,
      5,
      0.116643,
      22.079661,
      1,
      1,
      0.219841,
      1.999057,
      ' 0-11-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      186,
      3.770274,
      ' 6- 7-1989',
      NULL,
      NULL,
      NULL,
      17,
      NULL,
      17,
      ' 0-26-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      49.201008,
      '11-14-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      15,
      ' 8- 3-1990',
      53.290655,
      3.253622,
      NULL,
      ' 6- 7-1982',
      1.733550,
      NULL,
      ' 4- 6-1998',
      NULL,
      17,
      3,
      63.578756,
      ' 4- 9-1978',
      49,
      1.076324,
      110,
      ' 3-10-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


