set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8723478';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      '3',
      '4',
      NULL,
      '1',
      '1',
      '2',
      '2',
      '2',
      '2',
      '1',
      NULL,
      NULL,
      '2',
      '2',
      '0',
      '0',
      '',
      '4',
      '',
      '3',
      NULL,
      '0',
      '4',
      NULL,
      '',
      '',
      '0',
      '2',
      '4',
      '3',
      '0',
      '2',
      '1',
      '0',
      NULL,
      '1',
      '1',
      '323',
      '04440321',
      53.262057,
      46.496713,
      '0100101',
      2,
      NULL,
      1,
      NULL,
      '323214',
      5,
      ' 5-18-1975',
      NULL,
      23,
      NULL,
      51.309535,
      6.706443,
      NULL,
      2,
      52,
      0,
      8,
      19.912389,
      38,
      17.715268,
      29.028425,
      19,
      35,
      7.080434,
      NULL,
      11,
      26,
      NULL,
      37,
      9,
      63,
      18,
      1.191813,
      NULL,
      33,
      62,
      96.733345,
      128,
      NULL,
      ' 0-19-1993',
      NULL,
      38.035183,
      25,
      27.588305,
      102.582203,
      144,
      ' 2-18-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      74.317283,
      12,
      2,
      10.165689,
      NULL,
      11.803942,
      '10-25-2003',
      1,
      0,
      NULL,
      0,
      3.161934,
      NULL,
      1.290644,
      0.590515,
      75,
      NULL,
      NULL,
      NULL,
      ' 4- 1-1997',
      73.820243,
      44,
      61,
      0,
      NULL,
      NULL,
      21.516783,
      105.098150,
      78.227887,
      NULL,
      NULL,
      49.545641,
      NULL,
      NULL,
      3.567972,
      8,
      42,
      NULL,
      NULL,
      NULL,
      ' 5-25-2000',
      11.681074,
      8.152668,
      NULL,
      6,
      8.876445,
      10.584282,
      18.432041,
      3.072496,
      NULL,
      0,
      7,
      0.253118,
      29.317495,
      1.925459,
      8,
      16.523997,
      3.533005,
      0,
      0.116053,
      0.219199,
      NULL,
      ' 9-11-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      55.666602,
      '10-12-1998',
      33.852925,
      ' 9- 2-1990',
      2.772726,
      17,
      ' 2- 5-1993',
      NULL,
      29,
      '10-21-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      9.118553,
      ' 8- 5-1987',
      3.061558,
      14.708858,
      12.266858,
      ' 9- 5-1980',
      1,
      43,
      '11-27-1987',
      NULL,
      NULL,
      15,
      8.809167,
      ' 3-19-1994',
      NULL,
      1.828360,
      68.537350,
      ' 8-28-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


