set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8723478';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      NULL,
      '1',
      NULL,
      '3',
      NULL,
      '1',
      NULL,
      '0',
      '4',
      '3',
      '2',
      '1',
      NULL,
      '1',
      '2',
      '0',
      '3',
      '2',
      '2',
      '0',
      '1',
      '1',
      '3',
      '',
      NULL,
      '',
      '4',
      '1',
      '0',
      '3',
      '1',
      '',
      '',
      '3',
      '0',
      '3',
      '4',
      '2',
      '0',
      NULL,
      '0',
      '0',
      '4',
      NULL,
      '120',
      '14003043',
      52.474723,
      26.251279,
      NULL,
      2,
      210,
      2,
      0,
      '434011',
      3.525565,
      '10- 6-2003',
      ' 9- 4-1984',
      39,
      NULL,
      6.958646,
      10.677465,
      14,
      12.525010,
      NULL,
      5.766617,
      NULL,
      NULL,
      17,
      NULL,
      NULL,
      22,
      28,
      18.000780,
      NULL,
      4.974806,
      31,
      NULL,
      25.438947,
      17.501572,
      67.041692,
      18.042388,
      0,
      98.202631,
      NULL,
      NULL,
      90,
      92.337343,
      211,
      ' 9-12-1976',
      73,
      54.024762,
      NULL,
      30.053783,
      NULL,
      14.237207,
      ' 1- 4-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      94.026163,
      NULL,
      NULL,
      NULL,
      2.115666,
      NULL,
      ' 2- 8-1990',
      1.039668,
      NULL,
      NULL,
      0,
      0.901662,
      45,
      1.866860,
      0.683453,
      85,
      NULL,
      NULL,
      NULL,
      ' 5-12-1992',
      NULL,
      86.116071,
      92.237002,
      22.947830,
      59,
      101.035392,
      NULL,
      NULL,
      NULL,
      85.275842,
      37,
      46,
      ' 7- 5-1987',
      NULL,
      28.823086,
      15.261054,
      45,
      27.085566,
      NULL,
      6,
      '10-15-1983',
      NULL,
      24.061129,
      NULL,
      15,
      NULL,
      22,
      3,
      NULL,
      6,
      1.134194,
      NULL,
      1.602518,
      NULL,
      1,
      0.619208,
      NULL,
      10,
      1,
      NULL,
      0.338163,
      1.595795,
      ' 1-11-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      272.259427,
      14,
      ' 0- 5-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-12-1985',
      10.472945,
      ' 8- 3-1997',
      5.503858,
      1.803558,
      ' 8-24-1991',
      115.025091,
      8.034298,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      5,
      ' 6-18-1989',
      43.076466,
      26,
      26.435482,
      ' 8-22-1977',
      1,
      4.165446,
      NULL,
      NULL,
      15,
      21,
      34.179468,
      NULL,
      46.650394,
      NULL,
      66.804984,
      '11-26-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


