set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7323170';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0041',
      '33302422',
      '31422020',
      '12431130',
      '32000123',
      NULL,
      NULL,
      '31042040',
      NULL,
      NULL,
      NULL,
      '40430020',
      '02122101',
      NULL,
      '42414104',
      '11232433',
      '30321134',
      '41113234',
      '43404033',
      NULL,
      '02231304',
      '30414202',
      '31413123',
      '01231321',
      NULL,
      '11043244',
      '10232143',
      '12003440',
      NULL,
      '23341310',
      '13013124',
      '04433044',
      '20212133',
      '13240013',
      '02313101',
      '44023001',
      '33222421',
      '11402304',
      '21001403',
      '31003124',
      '20241400',
      '12211224',
      '04101304',
      '32031243',
      '01410342',
      '034',
      '42',
      13,
      NULL,
      '4324302',
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      ' 7- 3-1993',
      ' 6-21-1975',
      86.120594,
      NULL,
      16,
      8.667509,
      11.812911,
      6,
      6,
      NULL,
      20.860428,
      NULL,
      17.909885,
      13,
      29,
      4,
      23,
      7,
      33.895978,
      20,
      NULL,
      NULL,
      NULL,
      16.351423,
      35,
      14.792694,
      NULL,
      30,
      104.199864,
      85.147845,
      183,
      33,
      NULL,
      '10- 0-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.231778,
      102,
      0.451196,
      3.447485,
      16.531534,
      0,
      2.742215,
      20,
      NULL,
      NULL,
      NULL,
      ' 5-15-1980',
      22.189304,
      9.275337,
      52,
      48.009360,
      48,
      83.369750,
      46.423735,
      34.570272,
      73.304573,
      NULL,
      NULL,
      68.415277,
      ' 3-22-1978',
      1.285709,
      14,
      10,
      NULL,
      1,
      NULL,
      6,
      ' 0-11-1982',
      NULL,
      NULL,
      NULL,
      0.377323,
      8.000190,
      20.653506,
      17,
      8.129428,
      NULL,
      0,
      5,
      0.162527,
      88,
      1.577042,
      4.352084,
      NULL,
      7.133280,
      0,
      0.847683,
      NULL,
      0.173408,
      ' 9-24-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      79,
      40,
      ' 5-27-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      8.656049,
      ' 9-20-1978',
      NULL,
      51.795335,
      36.169720,
      ' 3-25-1995',
      1.852153,
      81,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


