set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908573';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2441',
      '43120211',
      '03334404',
      '43143231',
      '42321011',
      NULL,
      '42040040',
      '23433401',
      '02104233',
      NULL,
      '12003342',
      '14324400',
      NULL,
      NULL,
      '30234341',
      '23402131',
      '13022032',
      '23012441',
      NULL,
      NULL,
      '03232414',
      '10133224',
      '04440221',
      '12413432',
      '04413202',
      '02312133',
      '42442420',
      '41214011',
      '01224304',
      '22324430',
      '22302011',
      '41033313',
      '02313430',
      '41123300',
      NULL,
      '01242123',
      '22140212',
      '30421013',
      '34140211',
      '31402011',
      '30321414',
      '40020023',
      '40010422',
      '41331443',
      '12341012',
      NULL,
      '',
      NULL,
      NULL,
      '0413441',
      3.783838,
      1,
      2,
      NULL,
      NULL,
      0,
      ' 3-10-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      17.657373,
      18.874254,
      3.387413,
      0,
      NULL,
      20,
      12,
      6,
      8,
      NULL,
      17.470959,
      24.648371,
      3.652431,
      4.066945,
      4,
      NULL,
      8.079101,
      NULL,
      10,
      90.908014,
      3,
      NULL,
      3,
      NULL,
      85.117683,
      178,
      21.775933,
      NULL,
      ' 5- 1-1978',
      NULL,
      NULL,
      28,
      NULL,
      NULL,
      NULL,
      '10-26-1981',
      0,
      NULL,
      1,
      4.212636,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      8.402135,
      2,
      0.327953,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-11-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-15-2000',
      NULL,
      89.978015,
      16,
      85,
      26.266097,
      7.803629,
      29.432690,
      81,
      NULL,
      43,
      77.473639,
      67,
      ' 3- 5-2003',
      26.670132,
      5,
      6,
      11,
      46.516485,
      NULL,
      5.021430,
      ' 5-24-1993',
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      10.824980,
      NULL,
      21,
      2,
      NULL,
      NULL,
      NULL,
      75.849341,
      13.403647,
      1,
      6.988409,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-19-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      22.266330,
      17.859537,
      '11- 0-1988',
      0,
      149,
      NULL,
      19,
      6.069894,
      11,
      NULL,
      ' 3-25-1974',
      66,
      0,
      NULL,
      ' 5-22-1990',
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      34,
      18.620486,
      31.232216,
      95,
      15,
      7.577328,
      10.805038,
      6,
      NULL,
      6.107454,
      0.548191,
      NULL,
      37.599552,
      1,
      4,
      2.578731,
      0,
      1.540173,
      14.836786,
      0.822933,
      7,
      NULL,
      42,
      28,
      3.880291,
      1.895671,
      NULL,
      1,
      0.970335,
      1.157970,
      NULL,
      1,
      0.799724,
      48.008223,
      14,
      71.326873,
      4,
      83,
      40.342662,
      1.452186,
      1.609985,
      63,
      NULL,
      9,
      4.784933,
      NULL,
      NULL,
      76,
      0.677542,
      NULL,
      3.921031,
      0.085761,
      12.129306,
      24.164539,
      10,
      31.501605,
      5.657141,
      39,
      16.665969,
      NULL,
      5.721530,
      0.786087,
      0,
      0.095099,
      NULL,
      0.218509,
      1.146555,
      1.618223,
      22,
      NULL,
      '11- 6-1977',
      ' 1-25-1991',
      ' 6-20-2003',
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


