set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908573';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4330',
      '30330202',
      '14332300',
      '34122430',
      NULL,
      '00423011',
      '13400110',
      '33343411',
      '12030323',
      '03104242',
      '34332001',
      '23233203',
      '02443123',
      NULL,
      '31000323',
      '00123400',
      '02201311',
      '10103313',
      NULL,
      NULL,
      '32141012',
      '41041410',
      '02040342',
      '41233141',
      '32044022',
      '12011412',
      '12122011',
      NULL,
      '04123334',
      NULL,
      NULL,
      '44433301',
      '20300011',
      NULL,
      '10243423',
      '34404322',
      '31100343',
      '23342300',
      '32433402',
      '21011412',
      '10141022',
      '33142300',
      '02330120',
      '02241134',
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      0.368463,
      1,
      0,
      NULL,
      '113143',
      0,
      '10-10-1978',
      NULL,
      NULL,
      NULL,
      17,
      14.133534,
      NULL,
      6,
      73.027807,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      44,
      NULL,
      NULL,
      NULL,
      58.227941,
      14.288759,
      NULL,
      NULL,
      NULL,
      NULL,
      88,
      NULL,
      34,
      ' 6- 7-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.065077,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.873421,
      1.101903,
      2.558379,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 4-1978',
      18,
      123.436713,
      8.428505,
      NULL,
      81,
      18,
      101.365523,
      86,
      34,
      8,
      46,
      27,
      ' 4-10-1996',
      NULL,
      12.560058,
      1.750457,
      35,
      23,
      NULL,
      2.602398,
      NULL,
      10,
      8,
      NULL,
      11,
      NULL,
      9,
      12.103358,
      10.650831,
      7.798649,
      NULL,
      9,
      NULL,
      27.558216,
      NULL,
      1.237746,
      3.459529,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-18-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17.417931,
      12.551287,
      16.126678,
      NULL,
      1,
      81,
      '10-22-1977',
      NULL,
      NULL,
      23,
      45,
      ' 3-16-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      49.384108,
      63.119838,
      48.204701,
      99.276806,
      40,
      14.007239,
      39,
      NULL,
      NULL,
      1.982333,
      3.638317,
      44.952660,
      0.720934,
      1,
      48.085306,
      0.580328,
      4.281558,
      46,
      1.540477,
      1,
      184.934083,
      63,
      NULL,
      NULL,
      1.011233,
      111.835132,
      NULL,
      0.001254,
      0,
      1,
      3.402798,
      0.592702,
      80.081776,
      74.835610,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      91,
      0,
      0,
      25,
      4.675358,
      8.114710,
      26,
      NULL,
      91.013677,
      NULL,
      NULL,
      3,
      3.992861,
      1.359732,
      1.840556,
      0,
      1,
      1,
      1.867614,
      89.093561,
      ' 5- 2-1983',
      NULL,
      NULL,
      NULL,
      ' 1-17-2001',
      NULL,
      ' 4-21-1984',
      NULL);
commit;
end;
/


