set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908573';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0340',
      NULL,
      NULL,
      '44020420',
      '40343342',
      '23243241',
      '23342212',
      '03242031',
      NULL,
      NULL,
      '20210414',
      '34141134',
      '30200034',
      '13440213',
      '30113300',
      '14011420',
      NULL,
      NULL,
      '21232042',
      '43044232',
      '14423301',
      '10104310',
      '20032210',
      NULL,
      '33333113',
      NULL,
      '21031310',
      NULL,
      NULL,
      NULL,
      '12403113',
      '00333114',
      '20114130',
      '43331231',
      '10021334',
      NULL,
      '32114134',
      '21313033',
      '14443020',
      '32234430',
      '32134111',
      '03442110',
      '32030142',
      NULL,
      '03210024',
      '212',
      NULL,
      NULL,
      NULL,
      '2423204',
      NULL,
      NULL,
      0,
      NULL,
      '401021',
      NULL,
      ' 5- 7-1974',
      ' 7-11-2000',
      59,
      NULL,
      13.163555,
      11,
      7.729447,
      4.965295,
      16,
      9.585672,
      2,
      2,
      11.856840,
      14.657590,
      NULL,
      NULL,
      16,
      4.833702,
      1.823065,
      7,
      NULL,
      17,
      25.653294,
      NULL,
      41.178531,
      NULL,
      1.479880,
      57.968826,
      146,
      22.805789,
      144,
      175,
      45,
      ' 5-16-1988',
      44,
      27,
      NULL,
      15.433521,
      112,
      NULL,
      ' 4-13-1995',
      1,
      0.952269,
      0.718368,
      2,
      0,
      1.177593,
      6,
      NULL,
      NULL,
      NULL,
      1.399242,
      0.486370,
      1.936889,
      1,
      1,
      NULL,
      0.708758,
      0,
      1.907235,
      2.776001,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-16-1988',
      35.707384,
      12,
      9,
      10,
      5,
      0,
      ' 2-23-1984',
      1.725918,
      0,
      95,
      0,
      0,
      NULL,
      1,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-23-1978',
      51.527001,
      NULL,
      36,
      NULL,
      83,
      82,
      46.859582,
      NULL,
      39,
      55,
      36,
      45,
      ' 7-21-1997',
      NULL,
      23.144718,
      24,
      3,
      62,
      40.771454,
      NULL,
      ' 1- 8-1992',
      1.484387,
      NULL,
      ' 5-13-1983',
      10.180704,
      19.961253,
      12,
      6,
      21.877808,
      5,
      3.877402,
      9,
      0.616819,
      NULL,
      0.722748,
      1,
      7.460869,
      7.962442,
      NULL,
      5,
      10.123975,
      NULL,
      ' 1-20-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      42,
      12,
      ' 3-19-1977',
      NULL,
      NULL,
      NULL,
      37,
      ' 8- 7-1992',
      1.996186,
      ' 5-19-1981',
      7.988200,
      6,
      ' 8- 8-1979',
      NULL,
      NULL,
      NULL,
      3.951088,
      NULL,
      ' 3- 0-1985',
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      16.456158,
      ' 4-21-1991',
      34,
      10.275464,
      14.584422,
      ' 1- 6-1985',
      0,
      39,
      ' 9-26-1988',
      6.889264,
      0,
      21,
      17,
      '11-29-1990',
      11,
      NULL,
      21.278259,
      ' 1- 8-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


