set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908573';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '2',
      '1',
      '1',
      '3',
      NULL,
      NULL,
      '0',
      '2',
      NULL,
      NULL,
      '3',
      '1',
      '3',
      '3',
      NULL,
      NULL,
      '2',
      '4',
      NULL,
      '4',
      '0',
      '4',
      '1',
      NULL,
      '0',
      '',
      '3',
      '3',
      '1',
      NULL,
      NULL,
      '',
      '',
      NULL,
      '0',
      NULL,
      '1',
      NULL,
      NULL,
      '0',
      '3',
      '1',
      '4',
      NULL,
      '140',
      '11402040',
      38.872836,
      68.485761,
      '2121000',
      NULL,
      44,
      0,
      NULL,
      '404331',
      3,
      ' 7-10-1977',
      ' 1- 6-1982',
      11.398338,
      169,
      31.722290,
      NULL,
      6.241132,
      NULL,
      62.990353,
      2,
      20.692386,
      NULL,
      13.226208,
      12.784360,
      NULL,
      NULL,
      8.102690,
      1.518824,
      15.198265,
      20,
      22,
      NULL,
      28.419769,
      18.756283,
      81.435083,
      18,
      NULL,
      NULL,
      29,
      12.167109,
      72,
      27,
      NULL,
      NULL,
      NULL,
      61.509549,
      2,
      28.221945,
      80.900321,
      3.621723,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      63,
      15,
      20,
      NULL,
      0,
      1,
      ' 0-21-1979',
      1.290934,
      2.749965,
      149.053062,
      NULL,
      0,
      26.429983,
      0,
      0,
      85,
      NULL,
      NULL,
      NULL,
      ' 4-11-1996',
      72,
      71,
      28.324899,
      94.971611,
      62.951728,
      65,
      NULL,
      NULL,
      47.007390,
      58,
      NULL,
      0,
      ' 7-14-1990',
      NULL,
      NULL,
      9.869366,
      NULL,
      14.813591,
      NULL,
      9.017508,
      ' 5- 3-1994',
      4.861165,
      1,
      ' 3-26-1979',
      11,
      11,
      10,
      2,
      NULL,
      NULL,
      0.253582,
      4.623509,
      NULL,
      35.407668,
      NULL,
      NULL,
      1.267138,
      5.143313,
      0,
      8,
      NULL,
      0.966471,
      ' 1- 9-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      170.378516,
      5,
      ' 5-28-1989',
      NULL,
      NULL,
      NULL,
      39.416135,
      NULL,
      29,
      NULL,
      7.133345,
      5.147381,
      ' 5-12-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      19.811807,
      ' 2-21-1988',
      39.667361,
      32.862447,
      13,
      ' 4-26-1992',
      0,
      136.794129,
      ' 3-28-1990',
      NULL,
      4,
      12.327849,
      43,
      ' 4-19-1990',
      22,
      0.597173,
      158.058950,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


