set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908573';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '4',
      NULL,
      '2',
      '2',
      '0',
      '4',
      '3',
      NULL,
      '3',
      '3',
      '2',
      '3',
      '1',
      '4',
      '3',
      '3',
      NULL,
      NULL,
      '4',
      '0',
      '2',
      '4',
      NULL,
      '',
      '1',
      '',
      NULL,
      '0',
      '2',
      '0',
      '1',
      '',
      '',
      '2',
      NULL,
      '0',
      '0',
      NULL,
      '4',
      '0',
      '4',
      '4',
      '1',
      '0',
      '022',
      '21434014',
      50.056962,
      34.588892,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '230300',
      2.254888,
      ' 3-15-1992',
      ' 1-21-1983',
      NULL,
      NULL,
      0,
      0,
      18.227379,
      6,
      5,
      11.685709,
      6,
      NULL,
      23.806994,
      9,
      20.666771,
      NULL,
      15.925168,
      NULL,
      5.258154,
      14.326802,
      10,
      NULL,
      9.863083,
      9,
      86,
      1.368034,
      1,
      85.625823,
      105.616914,
      21.411119,
      155,
      NULL,
      123,
      '11-14-1975',
      25,
      NULL,
      14.243078,
      6,
      94.018861,
      162,
      ' 5-13-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      61.269784,
      35,
      27.476341,
      30.500902,
      25.437396,
      0.884543,
      ' 3- 4-2001',
      1.012993,
      0.442504,
      NULL,
      NULL,
      3,
      82,
      1.423817,
      0,
      86,
      NULL,
      NULL,
      NULL,
      ' 2-14-1998',
      47.791310,
      92,
      NULL,
      7.296811,
      50.600979,
      54.677312,
      95,
      77.921618,
      NULL,
      45,
      NULL,
      4.853702,
      '11-18-2002',
      1.114669,
      0.705139,
      NULL,
      0.034538,
      24,
      16.282668,
      11,
      NULL,
      12.673838,
      4.656153,
      ' 3-20-1982',
      NULL,
      NULL,
      7,
      1,
      NULL,
      0.831298,
      1,
      0.433998,
      0,
      40.066168,
      NULL,
      0.304735,
      1,
      6.752965,
      5,
      6.622421,
      1.115068,
      1.041405,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      42,
      0.137382,
      NULL,
      NULL,
      NULL,
      NULL,
      8.653499,
      ' 0- 2-2000',
      37,
      '11-22-1989',
      NULL,
      14,
      NULL,
      23.165010,
      32.945339,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.439518,
      NULL,
      22.533224,
      26.565789,
      NULL,
      ' 6-25-1980',
      NULL,
      NULL,
      ' 1- 5-2002',
      NULL,
      17,
      NULL,
      NULL,
      ' 8-14-1986',
      46,
      0,
      23,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


