set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9796819';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      NULL,
      NULL,
      '2',
      '4',
      '2',
      NULL,
      '2',
      '2',
      '0',
      NULL,
      NULL,
      '4',
      '1',
      '4',
      '4',
      NULL,
      '2',
      '2',
      '2',
      '0',
      '3',
      '1',
      '2',
      '',
      '4',
      '',
      '0',
      '1',
      NULL,
      '1',
      '0',
      '',
      '',
      '1',
      '0',
      '2',
      NULL,
      '3',
      '3',
      '2',
      '4',
      '2',
      '3',
      '3',
      '220',
      '32140334',
      54.300228,
      32.098739,
      '2422213',
      2,
      0.017842,
      1,
      NULL,
      '124120',
      5.031189,
      ' 9- 1-1990',
      ' 8-10-1992',
      NULL,
      151,
      3.275501,
      10,
      10.865651,
      NULL,
      NULL,
      12,
      9,
      11,
      16,
      9.718477,
      32,
      8.517980,
      0.011730,
      10.724773,
      13.774685,
      11,
      NULL,
      5,
      NULL,
      4.996507,
      111,
      18.326575,
      0.660765,
      11,
      128.583900,
      41.882291,
      85.402615,
      171,
      140,
      ' 2-22-1981',
      41.991617,
      NULL,
      26.198335,
      19.496445,
      NULL,
      199,
      ' 0- 9-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      34.905244,
      19.617397,
      16.835817,
      2,
      25.332576,
      1,
      ' 4- 2-2001',
      1,
      1,
      142,
      0.351550,
      1,
      NULL,
      NULL,
      3,
      1.439572,
      NULL,
      NULL,
      NULL,
      NULL,
      67.933246,
      44,
      38.703862,
      NULL,
      9,
      45.653963,
      13,
      24.656109,
      9,
      30.197818,
      39,
      4,
      ' 1-29-1992',
      19,
      24,
      10.772990,
      6.622013,
      20.106383,
      12,
      11,
      ' 8-26-1977',
      7,
      NULL,
      ' 3-17-1974',
      6,
      11.434875,
      NULL,
      10,
      15.490585,
      0.282791,
      1,
      5.206305,
      0,
      75.807873,
      0.759347,
      1.960116,
      NULL,
      3.816534,
      1.765798,
      3,
      NULL,
      1,
      '11-25-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 3-2002',
      NULL,
      NULL,
      NULL,
      16,
      ' 2-11-1982',
      40,
      '10-29-1978',
      8,
      11,
      ' 8-21-1996',
      57.647004,
      13.624404,
      ' 2- 8-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      NULL,
      NULL,
      0.577424,
      NULL,
      ' 7- 4-1977',
      1,
      83,
      ' 7-29-1999',
      NULL,
      9,
      15.796430,
      19,
      ' 0-26-1999',
      25,
      0.364282,
      166,
      ' 8- 6-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


