set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '4011710';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '04423430',
      '43142422',
      '44112411',
      '21130230',
      '21344444',
      '02041101',
      '00110340',
      '11301304',
      '34432234',
      '24111223',
      NULL,
      '04344000',
      '40000100',
      '40301322',
      '23042042',
      '40043413',
      '40442114',
      '22101420',
      '44123323',
      NULL,
      '34000333',
      '10234033',
      '14032122',
      '34332020',
      '12003401',
      '02144332',
      '40001013',
      '43331413',
      '11121402',
      '00402202',
      '02311234',
      '44414023',
      '02411210',
      NULL,
      '30444200',
      '04312023',
      '40101443',
      NULL,
      '01401330',
      '01013112',
      '31433130',
      '12420321',
      '41030333',
      '10242133',
      '',
      '',
      NULL,
      NULL,
      '2400210',
      2.294832,
      1.194766,
      2,
      NULL,
      NULL,
      1,
      ' 6-23-1982',
      NULL,
      22.858522,
      NULL,
      2.804786,
      10.606592,
      13,
      0.408285,
      5,
      8.110521,
      1.458984,
      5,
      10,
      NULL,
      0.350743,
      NULL,
      5,
      NULL,
      1,
      1.765213,
      7.973279,
      3.416773,
      4,
      1,
      NULL,
      2.959655,
      NULL,
      34,
      38,
      12,
      116.388135,
      11.232384,
      NULL,
      ' 0-12-1978',
      NULL,
      NULL,
      4.492951,
      NULL,
      NULL,
      NULL,
      ' 3-24-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-19-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      14,
      0,
      14,
      51.899831,
      27.383596,
      7.188377,
      NULL,
      5.037708,
      6.344648,
      NULL,
      0,
      5.026717,
      10,
      7.927286,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      6,
      NULL,
      0.667283,
      1.245027,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-27-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19,
      1.727283,
      NULL,
      ' 5- 0-1984',
      NULL,
      NULL,
      NULL,
      2,
      0.493055,
      1.450049,
      17,
      ' 1-13-1988',
      9,
      0.961694,
      NULL,
      '10-13-1998',
      NULL,
      NULL,
      NULL,
      0.195693,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.380438,
      247.067836,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.432205,
      41,
      NULL,
      NULL,
      0.111284,
      0,
      0,
      1,
      0,
      1,
      51.826510,
      NULL,
      22,
      17.917049,
      25.157516,
      2.396254,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      34,
      NULL,
      44.125451,
      1,
      1.264964,
      6.039711,
      14.924937,
      1.919132,
      9,
      41,
      36,
      0,
      33.907923,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      25,
      NULL,
      ' 2- 8-2002',
      ' 6-12-1977',
      ' 2-27-2001',
      NULL,
      ' 0- 7-1995',
      ' 9-20-1999',
      NULL);
commit;
end;
/


