set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9766685';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '3',
      NULL,
      NULL,
      '0',
      '2',
      '0',
      NULL,
      '2',
      '1',
      '1',
      '3',
      '0',
      '2',
      '2',
      '3',
      '4',
      '4',
      '3',
      '1',
      '1',
      '3',
      '1',
      '3',
      '',
      '3',
      '',
      '0',
      NULL,
      '0',
      NULL,
      '1',
      '',
      '',
      '0',
      NULL,
      '4',
      '2',
      '4',
      NULL,
      '1',
      '4',
      '2',
      '2',
      '4',
      '040',
      '24401213',
      NULL,
      50.896575,
      NULL,
      3,
      0,
      3,
      NULL,
      '420321',
      NULL,
      ' 9- 7-1988',
      ' 6-21-1976',
      NULL,
      NULL,
      8,
      NULL,
      6,
      NULL,
      26.589175,
      12.927950,
      NULL,
      6.848888,
      16,
      4.296104,
      13.569809,
      NULL,
      6.915625,
      3,
      NULL,
      8,
      41,
      7.807024,
      45,
      10.090845,
      46,
      2,
      1.670872,
      69.506725,
      NULL,
      40.319409,
      160,
      138.765832,
      3.673768,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13.810196,
      40.502037,
      5,
      10.036946,
      0,
      2,
      ' 5-26-1975',
      NULL,
      0,
      43,
      0.651828,
      7,
      88.692097,
      1,
      4.993199,
      35.611820,
      NULL,
      NULL,
      NULL,
      ' 1-28-1987',
      113.675500,
      NULL,
      83,
      64,
      79.242927,
      NULL,
      28,
      65.668132,
      NULL,
      6.333719,
      NULL,
      NULL,
      ' 8-19-1977',
      2.612020,
      11.387106,
      11.593347,
      45,
      NULL,
      1.964299,
      NULL,
      ' 6-24-1993',
      10,
      2,
      '11-12-1993',
      8,
      1.443588,
      NULL,
      NULL,
      0.795931,
      1.116107,
      1,
      9.800523,
      0,
      35,
      NULL,
      1,
      1.305143,
      5,
      2,
      2,
      1.866129,
      1.585432,
      ' 8- 3-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.147580,
      ' 7-20-1992',
      27.953390,
      NULL,
      5,
      10.229188,
      ' 4-26-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      37.720984,
      NULL,
      NULL,
      NULL,
      NULL,
      134,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-19-1983',
      12,
      1.381687,
      158.208354,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


